/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.client.ColorRegistry;
import com.unlikepaladin.pfm.client.model.PFMBakedModelSetPropertiesExtension;
import com.unlikepaladin.pfm.data.materials.VariantHelper;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.mixin.BasicItemModelAccessor;
import com.unlikepaladin.pfm.mixin.CompositeItemModelAccessor;
import com.unlikepaladin.pfm.mixin.ConditionItemModelAccessor;
import com.unlikepaladin.pfm.mixin.RangeDispatchItemModelAccessor;
import com.unlikepaladin.pfm.mixin.SelectItemModelAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PFMItemModel<T>
implements ItemModel {
    private final SpecialModelRenderer<T> specialModelType;
    private final BakedModel model;
    private final List<ItemTintSource> tints;
    private final List<ItemTintSource> pfm$parentTints = new ArrayList<ItemTintSource>();

    public PFMItemModel(BakedModel model, SpecialModelRenderer<T> specialModelType, List<ItemTintSource> tints) {
        this.model = model;
        this.tints = tints;
        this.specialModelType = specialModelType;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext transformationMode, @Nullable ClientLevel world, @Nullable LivingEntity user, int seed) {
        List<ItemTintSource> tintsToUse;
        int tintCount;
        if (this.specialModelType != null) {
            ItemStackRenderState.LayerRenderState specialLayerRenderState = state.newLayer();
            specialLayerRenderState.setupSpecialModel(this.specialModelType, this.specialModelType.extractArgument(stack), this.model);
        }
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        if (stack.hasFoil()) {
            layerRenderState.setFoilType(ItemStackRenderState.FoilType.STANDARD);
        }
        RenderType renderLayer = ItemBlockRenderTypes.getRenderType((ItemStack)stack);
        layerRenderState.setupBlockModel(this.model, renderLayer);
        if (ColorRegistry.itemColorProviders.containsKey(stack.getItem()) && this.pfm$parentTints.isEmpty()) {
            Item item = ColorRegistry.itemColorProviders.get(stack.getItem()).asItem();
            ResourceLocation parentModelId = (ResourceLocation)item.getDefaultInstance().get(DataComponents.ITEM_MODEL);
            ItemModel parentModel = Minecraft.getInstance().getModelManager().getItemModel(parentModelId);
            this.pfm$parentTints.addAll(this.exploreForTints(stack, parentModel, world, user, seed, transformationMode));
        }
        if ((tintCount = (tintsToUse = this.pfm$parentTints.isEmpty() ? this.tints : this.pfm$parentTints).size()) == 0 && stack.has(PFMComponents.COLOR_COMPONENT)) {
            tintCount = 2;
            tintsToUse = new ArrayList<ItemTintSource>(tintCount);
            tintsToUse.add((ItemTintSource)new Constant(0xFFFFFF));
            tintsToUse.add((ItemTintSource)new Constant(0xFFFFFF));
        }
        int[] tintArray = layerRenderState.prepareTintLayers(tintCount);
        for (int index = 0; index < tintCount; ++index) {
            tintArray[index] = index == 1 && stack.has(PFMComponents.COLOR_COMPONENT) ? ((DyeColor)stack.getOrDefault(PFMComponents.COLOR_COMPONENT, (Object)DyeColor.WHITE)).getMapColor().col : tintsToUse.get(index).calculate(stack, world, user);
        }
        if (stack.getItem() instanceof BlockItem && this.model instanceof PFMBakedModelSetPropertiesExtension) {
            ((PFMBakedModelSetPropertiesExtension)this.model).setBlockStateProperty(((BlockItem)stack.getItem()).getBlock().defaultBlockState());
            if (stack.has(PFMComponents.VARIANT_COMPONENT)) {
                ((PFMBakedModelSetPropertiesExtension)this.model).setVariant(VariantHelper.getVariant((ResourceLocation)stack.get(PFMComponents.VARIANT_COMPONENT)));
            }
        }
    }

    private List<ItemTintSource> exploreForTints(ItemStack itemStack, ItemModel model, ClientLevel world, LivingEntity user, int seed, ItemDisplayContext transformationMode) {
        ItemModel itemModel = model;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasicItemModelAccessor.class, CompositeItemModelAccessor.class, ConditionItemModelAccessor.class, SelectItemModelAccessor.class, RangeDispatchItemModelAccessor.class}, (Object)itemModel, n)) {
            case 0: {
                BasicItemModelAccessor accessor = (BasicItemModelAccessor)itemModel;
                return accessor.getTints();
            }
            case 1: {
                CompositeItemModelAccessor accessor = (CompositeItemModelAccessor)itemModel;
                for (ItemModel itemModel2 : accessor.getItemModels()) {
                    List<ItemTintSource> src = this.exploreForTints(itemStack, itemModel2, world, user, seed, transformationMode);
                    if (src.isEmpty()) continue;
                    return src;
                }
                break;
            }
            case 2: {
                ConditionItemModelAccessor accessor = (ConditionItemModelAccessor)itemModel;
                boolean property = accessor.getProperty().get(itemStack, world, user, seed, transformationMode);
                if (property) {
                    return this.exploreForTints(itemStack, accessor.getOnTrue(), world, user, seed, transformationMode);
                }
                return this.exploreForTints(itemStack, accessor.getOnFalse(), world, user, seed, transformationMode);
            }
            case 3: {
                SelectItemModelAccessor accessor = (SelectItemModelAccessor)itemModel;
                ItemModel itemModel3 = (ItemModel)accessor.getModels().get(accessor.getProperty().get(itemStack, world, user, seed, transformationMode));
                return this.exploreForTints(itemStack, itemModel3, world, user, seed, transformationMode);
            }
            case 4: {
                int i;
                RangeDispatchItemModelAccessor accessor = (RangeDispatchItemModelAccessor)itemModel;
                float select = accessor.getProperty().get(itemStack, world, user, seed) * accessor.getScale();
                ItemModel itemModel4 = Float.isNaN(select) ? accessor.getFallback() : ((i = RangeDispatchItemModelAccessor.getIndex(accessor.getThresholds(), select)) == -1 ? accessor.getFallback() : accessor.getModels()[i]);
                return this.exploreForTints(itemStack, itemModel4, world, user, seed, transformationMode);
            }
            default: {
                return List.of();
            }
        }
        return List.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation model, Optional<SpecialModelRenderer.Unbaked> specialModel, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)SpecialModelRenderers.CODEC.optionalFieldOf("special_model").forGetter(Unbaked::specialModel), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)instance, Unbaked::new));

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.resolve(this.model);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            BakedModel bakedModel = context.bake(this.model);
            if (this.specialModel.isPresent()) {
                SpecialModelRenderer specialModelRenderer = this.specialModel.get().bake(context.entityModelSet());
                return new PFMItemModel(bakedModel, specialModelRenderer, this.tints);
            }
            return new PFMItemModel(bakedModel, null, this.tints);
        }

        public MapCodec<Unbaked> type() {
            return CODEC;
        }
    }
}

