/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unlikepaladin.pfm.blocks.models.basicLamp.UnbakedBasicLampModel;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class PFMItemRenderer {
    public static final PFMItemRenderer INSTANCE = new PFMItemRenderer();
    static Map<WoodVariant, Map<String, BakedModel>> bakedModels = new LinkedHashMap<WoodVariant, Map<String, BakedModel>>();
    static List<String> modelParts = new ArrayList<String>();

    public BakedModel getLampPartFromVariant(WoodVariant variantBase, int index) {
        if (!bakedModels.isEmpty() && !modelParts.isEmpty()) {
            return bakedModels.get(variantBase).get(modelParts.get(index));
        }
        modelParts.clear();
        bakedModels.clear();
        modelParts.addAll(UnbakedBasicLampModel.MODEL_PARTS_BASE);
        modelParts.addAll(UnbakedBasicLampModel.STATIC_PARTS);
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            bakedModels.put(woodVariant, new LinkedHashMap());
            for (String part : modelParts) {
                bakedModels.get(woodVariant).put(part, Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)part.replaceAll("template", woodVariant.getSerializedName())), "inventory")));
            }
        }
        return bakedModels.get(variantBase).get(modelParts.get(index));
    }

    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (stack.is(PaladinFurnitureModBlocksItems.BASIC_LAMP_ITEM)) {
            WoodVariant variant = WoodVariantRegistry.OAK;
            if (stack.has(PFMComponents.VARIANT_COMPONENT)) {
                variant = WoodVariantRegistry.getVariant((ResourceLocation)stack.get(PFMComponents.VARIANT_COMPONENT));
            }
            boolean glint = stack.hasFoil();
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            boolean leftHanded = Minecraft.getInstance().player != null && Minecraft.getInstance().player.getMainArm() == HumanoidArm.LEFT && mode.firstPerson();
            VertexConsumer consumer = ItemRenderer.getFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)stack), (boolean)true, (boolean)glint);
            matrices.popPose();
            matrices.translate(-0.5, -0.5, -0.5);
            BakedModel poleModel = this.getLampPartFromVariant(variant, 2);
            BakedModel bulbModel = this.getLampPartFromVariant(variant, 5);
            matrices.pushPose();
        }
    }
}

