/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.menus.AbstractMicrowaveScreenHandler;
import com.unlikepaladin.pfm.menus.MicrowaveScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipePropertySet;

public class MicrowaveScreen
extends AbstractContainerScreen<MicrowaveScreenHandler> {
    private final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"textures/gui/container/microwave.png");
    private boolean narrow;
    public boolean isActive;
    private MicrowaveBlockEntity microwaveBlockEntity;
    private RecipePropertySet recipePropertySet;
    private final Component startButtonText = Component.translatable((String)"gui.pfm.microwave.start_button");
    public Button startButton;

    public MicrowaveScreen(MicrowaveScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void init() {
        super.init();
        this.microwaveBlockEntity = ((MicrowaveScreenHandler)this.menu).microwaveBlockEntity;
        this.isActive = ((MicrowaveScreenHandler)this.menu).getActive();
        this.narrow = this.width < 379;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.startButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder(this.startButtonText, button -> AbstractMicrowaveScreenHandler.setActive(this.microwaveBlockEntity, true)).pos(this.leftPos + 8, this.topPos + 40).size(40, 20).build());
        if (this.recipePropertySet == null) {
            this.recipePropertySet = this.microwaveBlockEntity.getLevel().recipeAccess().propertySet(RecipePropertySet.SMOKER_INPUT);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.narrow) {
            this.renderBackground(context, mouseX, mouseY, delta);
        } else {
            super.render(context, mouseX, mouseY, delta);
        }
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        context.blit(RenderType::guiTextured, this.background, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int k = ((MicrowaveScreenHandler)this.menu).getCookProgress();
        k = Math.round((float)k * 1.75f);
        context.blit(RenderType::guiTextured, this.background, i + 147, j + 66 + -k, 176.0f, (float)(40 - k), 13, k + 1, 256, 256);
    }

    protected void containerTick() {
        super.containerTick();
        this.isActive = ((MicrowaveScreenHandler)this.menu).isActive;
        this.startButton.active = !this.recipePropertySet.test(this.microwaveBlockEntity.getItem(0)) && !((MicrowaveScreenHandler)this.menu).isActive() ? false : !((MicrowaveScreenHandler)this.menu).isActive();
    }
}

