/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.client.screens.widget.PFMOptionListWidget;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.Side;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class PFMConfigScreen
extends Screen {
    private final Screen parent;
    private PFMOptionListWidget optionListWidget;
    public AbstractConfigOption<?> focusedConfigOption;
    private Button resetButton;
    private final HashMap<String, AbstractConfigOption> options;
    private final Minecraft client;
    public static boolean isOnServer = false;
    private final MutableComponent TITLE;

    public PFMConfigScreen(Minecraft client, Screen parent) {
        super((Component)Component.translatable((String)"pfm.config.title"));
        this.parent = parent;
        this.client = client;
        this.TITLE = Component.translatable((String)"pfm.config.title");
        this.options = PaladinFurnitureMod.getPFMConfig().options;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && !this.optionListWidget.hasChanges.isEmpty()) {
            this.client.setScreen((Screen)new ConfirmScreen(t -> {
                if (t) {
                    this.optionListWidget.save();
                    try {
                        PaladinFurnitureMod.getPFMConfig().save();
                    }
                    catch (IOException e) {
                        PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to save config options!");
                        throw new RuntimeException(e);
                    }
                }
                Minecraft.getInstance().setScreen(this.parent);
            }, (Component)Component.translatable((String)"gui.pfm.changesMightNotBeSaved").setStyle(Style.EMPTY.withColor(16219956).withBold(Boolean.valueOf(true))), (Component)Component.translatable((String)"gui.pfm.saveChanges")));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.optionListWidget.save();
        Minecraft.getInstance().setScreen(this.parent);
        try {
            PaladinFurnitureMod.getPFMConfig().save();
        }
        catch (IOException e) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Failed to save config options!");
            throw new RuntimeException(e);
        }
    }

    protected void init() {
        super.init();
        this.optionListWidget = new PFMOptionListWidget(this, this.client);
        this.addWidget((GuiEventListener)this.optionListWidget);
        this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"pfm.option.resetAll"), button -> this.options.forEach((title, option) -> {
            if (option.getSide() == Side.CLIENT) {
                if (option.getType() == Boolean.class) {
                    if (option.getDefaultValue() != this.optionListWidget.newConfigValues.get(option)) {
                        this.optionListWidget.hasChanges.set((int)this.optionListWidget.configOptionToIndexForHasChanges.get(option), true);
                    }
                    this.optionListWidget.newConfigValues.put((AbstractConfigOption)option, (Boolean)option.getDefaultValue());
                }
            } else if (!isOnServer && option.getSide() == Side.SERVER && option.getType() == Boolean.class) {
                if (option.getDefaultValue() != this.optionListWidget.newConfigValues.get(option)) {
                    this.optionListWidget.hasChanges.set((int)this.optionListWidget.configOptionToIndexForHasChanges.get(option), true);
                }
                this.optionListWidget.newConfigValues.put((AbstractConfigOption)option, (Boolean)option.getDefaultValue());
            }
        })).bounds(this.width / 2 - 155, this.height - 29, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.optionListWidget.save();
            this.client.setScreen(this.parent);
            try {
                PaladinFurnitureMod.getPFMConfig().save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).bounds(this.width / 2 - 155 + 160, this.height - 29, 150, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.optionListWidget != null) {
            this.optionListWidget.render(context, mouseX, mouseY, delta);
        }
        context.drawCenteredString(this.font, (Component)this.TITLE.setStyle(Style.EMPTY.withColor(16219956).withBold(Boolean.valueOf(true))), this.width / 2, 8, 0xFFFFFF);
        boolean bl = false;
        for (Map.Entry<AbstractConfigOption, Boolean> optionEntry : this.optionListWidget.newConfigValues.entrySet()) {
            if (optionEntry.getValue() == optionEntry.getKey().getDefaultValue()) continue;
            bl = true;
            break;
        }
        this.resetButton.active = bl;
    }
}

