/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.unlikepaladin.pfm.blocks.blockentities.TrashcanBlockEntity;
import com.unlikepaladin.pfm.menus.TrashcanScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TrashcanScreen
extends AbstractContainerScreen<TrashcanScreenHandler> {
    private static final ResourceLocation background = ResourceLocation.parse((String)"textures/gui/container/dispenser.png");
    private TrashcanBlockEntity trashcanBlockEntity;
    private boolean narrow;
    private Button startButton;
    private static final Component startButtonText = Component.translatable((String)"gui.pfm.trashcan.clear_button");

    public TrashcanScreen(TrashcanScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void init() {
        super.init();
        this.trashcanBlockEntity = ((TrashcanScreenHandler)this.menu).trashcanBlockEntity;
        this.narrow = this.width < 379;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.startButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder(startButtonText, button -> TrashcanScreenHandler.clear(this.trashcanBlockEntity)).pos(this.leftPos + 8, this.topPos + 40).size(40, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.narrow) {
            this.renderBackground(context, mouseX, mouseY, delta);
        } else {
            super.render(context, mouseX, mouseY, delta);
        }
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        context.blit(RenderType::guiTextured, background, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }
}

