/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"pfm:textures/gui/container/working_table.png");
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int RECIPE_LIST_COLUMNS = 6;
    private static final int RECIPE_LIST_ROWS = 3;
    private static final int RECIPE_ENTRY_WIDTH = 16;
    private static final int RECIPE_ENTRY_HEIGHT = 18;
    private static final int SCROLLBAR_AREA_HEIGHT = 54;
    private static final int RECIPE_LIST_OFFSET_X = 20;
    private static final int RECIPE_LIST_OFFSET_Y = 30;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;
    private EditBox searchBox;
    private final Set<TagKey<Item>> searchResultTags = new HashSet<TagKey<Item>>();

    public WorkbenchScreen(WorkbenchScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.canCraft = handler.canCraft();
    }

    protected void init() {
        super.init();
        Objects.requireNonNull(this.font);
        this.searchBox = new EditBox(this.font, this.leftPos + 20, this.topPos + 18, 110, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.addWidget((GuiEventListener)this.searchBox);
        this.imageHeight = 180;
        this.imageWidth = 176;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    public void resize(Minecraft client, int width, int height) {
        String string = this.searchBox.getValue();
        this.init(client, width, height);
        this.searchBox.setValue(string);
        if (!this.searchBox.getValue().isEmpty()) {
            this.search();
        }
    }

    public boolean charTyped(char chr, int modifiers) {
        String string = this.searchBox.getValue();
        if (this.searchBox.charTyped(chr, modifiers)) {
            if (!Objects.equals(string, this.searchBox.getValue())) {
                this.search();
            }
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean bl2 = InputConstants.getKey((int)keyCode, (int)scanCode).getNumericKeyValue().isPresent();
        if (bl2 && this.checkHotbarKeyPressed(keyCode, scanCode)) {
            return true;
        }
        String string = this.searchBox.getValue();
        if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.getValue())) {
                this.search();
            }
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && keyCode != 256) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void search() {
        ((WorkbenchScreenHandler)this.menu).getSearchableRecipes().clear();
        this.searchResultTags.clear();
        String string = this.searchBox.getValue();
        if (string.isEmpty()) {
            ((WorkbenchScreenHandler)this.menu).updateInput();
            ((WorkbenchScreenHandler)this.menu).searching = false;
        } else {
            ((WorkbenchScreenHandler)this.menu).updateInput();
            ClientPacketListener clientPlayNetworkHandler = this.minecraft.getConnection();
            if (clientPlayNetworkHandler != null) {
                SearchTree searchable;
                SessionSearchTrees searchManager = clientPlayNetworkHandler.searchTrees();
                if (string.startsWith("#")) {
                    string = string.substring(1);
                    searchable = searchManager.creativeTagSearch();
                    this.searchForTags(string);
                } else {
                    searchable = searchManager.creativeNameSearch();
                }
                ArrayList items = new ArrayList();
                searchable.search(string.toLowerCase(Locale.ROOT)).forEach(itemStack -> items.add(itemStack.getItem()));
                ((WorkbenchScreenHandler)this.menu).getSortedRecipes().forEach(furnitureRecipe -> {
                    if (items.contains(furnitureRecipe.result().getItem())) {
                        ((WorkbenchScreenHandler)this.menu).getSearchableRecipes().add((FurnitureRecipe)furnitureRecipe);
                    }
                });
                ((WorkbenchScreenHandler)this.menu).searching = true;
            }
        }
        this.scrollAmount = 0.0f;
        this.scrollOffset = 0;
    }

    private void searchForTags(String id) {
        Predicate<ResourceLocation> predicate;
        int i = id.indexOf(58);
        if (i == -1) {
            predicate = idx -> idx.getPath().contains(id);
        } else {
            String string = id.substring(0, i).trim();
            String string2 = id.substring(i + 1).trim();
            predicate = idx -> idx.getNamespace().contains(string) && idx.getPath().contains(string2);
        }
        Stream<TagKey> keyStream = BuiltInRegistries.ITEM.getTags().filter(tagKey -> predicate.test(tagKey.key().location())).map(HolderSet.Named::key);
        keyStream.forEach(this.searchResultTags::add);
    }

    public void containerTick() {
        super.containerTick();
        if (this.searchBox != null) {
            // empty if block
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int x = this.leftPos;
        int y = this.topPos;
        context.blit(RenderType::guiTextured, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int k = (int)(41.0f * this.scrollAmount);
        context.blit(RenderType::guiTextured, TEXTURE, x + 119, y + 31 + k, (float)(176 + (this.shouldScroll() ? 0 : 12)), 0.0f, 12, 15, 256, 256);
        int xOffSetForIcons = this.leftPos + 20;
        int yOffsetForIcons = this.topPos + 30;
        int scrollOffsetForIcons = this.scrollOffset + 18;
        this.renderRecipeBackground(context, mouseX, mouseY, xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.renderRecipeIcons(context, xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.searchBox.render(context, mouseX, mouseY, delta);
    }

    protected void renderTooltip(GuiGraphics context, int x, int y) {
        super.renderTooltip(context, x, y);
        int xOffsetForTooltip = this.leftPos + 20;
        int yOffsetForTooltip = this.topPos + 30;
        int scrollOffsetForTooltip = this.scrollOffset + 18;
        for (int recipeIndex = this.scrollOffset; recipeIndex < scrollOffsetForTooltip && recipeIndex < ((WorkbenchScreenHandler)this.menu).getVisibleRecipeCount(); ++recipeIndex) {
            int m = recipeIndex - this.scrollOffset;
            int n = xOffsetForTooltip + m % 6 * 16;
            int o = yOffsetForTooltip + m / 6 * 18 + 2;
            if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            int iCopy = recipeIndex;
            if (((WorkbenchScreenHandler)this.menu).searching) {
                iCopy = ((WorkbenchScreenHandler)this.menu).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.menu).getSearchableRecipes().get(iCopy));
            }
            tooltip.add((Component)this.getTooltipFromContainerItem(((WorkbenchScreenHandler)this.menu).getSortedRecipes().get(iCopy).result()).get(0));
            tooltip.add(Component.translatable((String)"container.pfm.working_table.ingredient_required").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
            HashMap<Item, Integer> itemStackCountMap = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((WorkbenchScreenHandler)this.menu).getSortedRecipes().get(iCopy).getIngredients()) {
                for (Holder item2 : ingredient.items().toList()) {
                    if (!itemStackCountMap.containsKey(item2.value())) {
                        itemStackCountMap.put((Item)item2.value(), 1);
                        continue;
                    }
                    itemStackCountMap.put((Item)item2.value(), (Integer)itemStackCountMap.get(item2.value()) + 1);
                }
            }
            itemStackCountMap.forEach((item, integer) -> {
                int itemCount = 0;
                Style style = Style.EMPTY.withColor(ChatFormatting.GRAY);
                for (ItemStack stack1 : ((WorkbenchScreenHandler)this.menu).getPlayerInventory().items) {
                    if (!stack1.is(item)) continue;
                    itemCount += stack1.getCount();
                }
                if (itemCount < integer) {
                    style = style.withColor(ChatFormatting.RED);
                }
                tooltip.add(Component.literal((String)(integer + " ")).append((Component)Component.literal((String)((Component)this.getTooltipFromContainerItem(item.getDefaultInstance()).get(0)).getString())).setStyle(style));
            });
            context.renderComponentTooltip(this.font, tooltip, x, y);
        }
    }

    private void renderRecipeBackground(GuiGraphics context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.menu).getVisibleRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 6 * 16;
            int l = j / 6;
            int m = y + l * 18 + 2;
            int v = this.imageHeight;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.menu).searching) {
                iCopy = ((WorkbenchScreenHandler)this.menu).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.menu).getSearchableRecipes().get(iCopy));
            }
            if (iCopy == ((WorkbenchScreenHandler)this.menu).getSelectedRecipe()) {
                v += 55;
            } else if (!((WorkbenchScreenHandler)this.menu).getAvailableRecipes().contains(((WorkbenchScreenHandler)this.menu).getSortedRecipes().get(iCopy))) {
                v += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                v += 36;
            }
            context.blit(RenderType::guiTextured, TEXTURE, k, m - 1, 0.0f, (float)v, 16, 18, 256, 256);
        }
    }

    private void renderRecipeIcons(GuiGraphics context, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.menu).getVisibleRecipeCount(); ++i) {
            int iMinusScrollOffset = i - this.scrollOffset;
            int xOffset = x + iMinusScrollOffset % 6 * 16;
            int l = iMinusScrollOffset / 6;
            int yOffset = y + l * 18 + 2;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.menu).searching) {
                iCopy = ((WorkbenchScreenHandler)this.menu).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.menu).getSearchableRecipes().get(iCopy));
            }
            context.renderItem(((WorkbenchScreenHandler)this.menu).getSortedRecipes().get(iCopy).result(), xOffset, yOffset);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int xOffsetForMouseClick = this.leftPos + 20;
            int yOffsetForMouseClick = this.topPos + 30;
            int scrollOffsetForMouseClick = this.scrollOffset + 18;
            for (int clickedRecipeId = this.scrollOffset; clickedRecipeId < scrollOffsetForMouseClick; ++clickedRecipeId) {
                int m = clickedRecipeId - this.scrollOffset;
                double d = mouseX - (double)(xOffsetForMouseClick + m % 6 * 16);
                double e = mouseY - (double)(yOffsetForMouseClick + m / 6 * 18);
                int clickedRecipeIdCopy = clickedRecipeId;
                if (((WorkbenchScreenHandler)this.menu).searching) {
                    clickedRecipeIdCopy = clickedRecipeIdCopy < ((WorkbenchScreenHandler)this.menu).getSearchableRecipes().size() ? ((WorkbenchScreenHandler)this.menu).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.menu).getSearchableRecipes().get(clickedRecipeIdCopy)) : -1;
                }
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WorkbenchScreenHandler)this.menu).clickMenuButton((Player)this.minecraft.player, clickedRecipeIdCopy))) continue;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((WorkbenchScreenHandler)this.menu).containerId, clickedRecipeIdCopy);
                return true;
            }
            xOffsetForMouseClick = this.leftPos + 119;
            yOffsetForMouseClick = this.topPos + 9;
            if (mouseX >= (double)xOffsetForMouseClick && mouseX < (double)(xOffsetForMouseClick + 12) && mouseY >= (double)yOffsetForMouseClick && mouseY < (double)(yOffsetForMouseClick + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.topPos + 30;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = Mth.clamp((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 6;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - verticalAmount / (double)i);
            this.scrollAmount = Mth.clamp((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 6;
        }
        return true;
    }

    private boolean shouldScroll() {
        return ((WorkbenchScreenHandler)this.menu).getVisibleRecipeCount() > 18;
    }

    protected int getMaxScroll() {
        return (((WorkbenchScreenHandler)this.menu).getVisibleRecipeCount() + 6 - 1) / 6 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((WorkbenchScreenHandler)this.menu).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

