/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge;

import com.unlikepaladin.pfm.blocks.blockentities.neoforge.FreezerBlockEntityImpl;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntityBalm
extends FreezerBlockEntityImpl
implements BalmContainerProvider,
BalmProviderHolder {
    private final KitchenItemProvider itemProvider = new ContainerKitchenItemProvider(this, (Container)this){
        private final ItemStack snowStack = new ItemStack((ItemLike)Items.SNOWBALL);
        private final ItemStack iceStack = new ItemStack((ItemLike)Blocks.ICE);

        public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            IngredientToken result = this.applyIceUnit(arg_0 -> ((Ingredient)ingredient).test(arg_0));
            if (result != null) {
                return result;
            }
            return super.findIngredient(ingredient, ingredientTokens, cacheHint);
        }

        public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            IngredientToken result = this.applyIceUnit(stack -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack));
            if (result != null) {
                return result;
            }
            return super.findIngredient(itemStack, ingredientTokens, cacheHint);
        }

        @Nullable
        private IngredientToken applyIceUnit(Function<ItemStack, Boolean> predicate) {
            if (predicate.apply(this.snowStack).booleanValue()) {
                return new FridgeBlockEntity.IceUnitIngredientToken(ContainerUtils.copyStackWithSize((ItemStack)this.snowStack, (int)64));
            }
            return predicate.apply(this.iceStack) != false ? new FridgeBlockEntity.IceUnitIngredientToken(ContainerUtils.copyStackWithSize((ItemStack)this.iceStack, (int)64)) : null;
        }
    };

    public FreezerBlockEntityBalm(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public Container getContainer() {
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return List.of(new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider));
    }
}

