/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge;

import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.blockentities.StovePacket;
import com.unlikepaladin.pfm.blocks.neoforge.StoveBlockImpl;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.CounterOvenBlockEntityBalm;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.FridgeBlockEntityBalm;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.GenericStorageBlockEntityBalm3x3;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.GenericStorageBlockEntityBalm9x3;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.PFMCookingTableBlock;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.StoveBlockEntityBalm;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.menu.StoveScreenHandlerBalm;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.TriFunc;
import com.unlikepaladin.pfm.registry.dynamic.LateBlockRegistry;
import java.util.Collection;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.neoforge.provider.NeoForgeBalmProviders;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class PFMCookingForBlockHeadsCompat {
    public static final PFMCookingTableBlock COOKING_TABLE_BLOCK = new PFMCookingTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_CONCRETE).setId(LateBlockRegistry.getBlockRegistryKey("cooking_table")));

    public static TriFunc<Integer, Inventory, StoveScreenHandler.StoveData, StoveScreenHandlerBalm> getStoveScreenHandler() {
        return (integer, playerInventory, data) -> {
            BlockPos pos = data.pos();
            BlockEntity blockEntity = playerInventory.player.level().getBlockEntity(pos);
            return new StoveScreenHandlerBalm((int)integer, (Inventory)playerInventory, (StoveBlockEntityBalm)blockEntity);
        };
    }

    public static <D extends StovePacket> StreamCodec<RegistryFriendlyByteBuf, D> getStovePacket() {
        return StoveScreenHandler.PACKET_CODEC;
    }

    public static void openMenuScreen(Level world, BlockPos pos, Player player) {
        StoveBlockEntityBalm stove = (StoveBlockEntityBalm)world.getBlockEntity(pos);
        if (!world.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)stove);
        }
    }

    public static BlockEntity getStoveBlockEntity(BlockPos pos, BlockState state) {
        return new StoveBlockEntityBalm(pos, state);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getStoveTicker(Level world, BlockEntityType<T> type) {
        if (world.isClientSide) {
            return StoveBlockImpl.checkType(type, BlockEntities.STOVE_BLOCK_ENTITY, StoveBlockEntityBalm::clientTick);
        }
        return StoveBlockImpl.checkType(type, BlockEntities.STOVE_BLOCK_ENTITY, StoveBlockEntityBalm::serverTick);
    }

    public static InteractionResult onUseStove(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == ModItems.heatingUnit) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (hit.getDirection() == Direction.UP && heldItem.is(ModItemTags.UTENSILS)) {
            StoveBlockEntityBalm tileOven;
            Direction stateFacing = (Direction)state.getValue((Property)StoveBlock.FACING);
            double hx = hit.getLocation().x - (double)hit.getBlockPos().getX();
            double hz = hit.getLocation().z - (double)hit.getBlockPos().getZ();
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - (hit.getLocation().x - (double)hit.getBlockPos().getX());
                    hz = 1.0 - (hit.getLocation().z - (double)hit.getBlockPos().getZ());
                    break;
                }
                case WEST: {
                    hz = 1.0 - (hit.getLocation().x - (double)hit.getBlockPos().getX());
                    hx = hit.getLocation().z - (double)hit.getBlockPos().getZ();
                    break;
                }
                case EAST: {
                    hz = hit.getLocation().x - (double)hit.getBlockPos().getX();
                    hx = 1.0 - (hit.getLocation().z - (double)hit.getBlockPos().getZ());
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (StoveBlockEntityBalm)level.getBlockEntity(pos)) != null && tileOven.getToolItem(index).isEmpty()) {
                ItemStack toolItem = heldItem.split(1);
                tileOven.setToolItem(index, toolItem);
            }
            return InteractionResult.SUCCESS;
        }
        StoveBlockEntityBalm oven = (StoveBlockEntityBalm)level.getBlockEntity(pos);
        if (hit.getDirection() == state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) && oven != null) {
            if (player.isShiftKeyDown()) {
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && oven.getSmeltingResult(heldItem) != ItemStack.EMPTY) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getInputContainer(), (ItemStack)heldItem, (boolean)false);
                player.setItemInHand(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && StoveBlockEntityBalm.isItemFuel(level, heldItem)) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getFuelContainer(), (ItemStack)heldItem, (boolean)false);
                player.setItemInHand(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)oven);
        }
        return InteractionResult.SUCCESS;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.FREEZER_BLOCK_ENTITY, (entity, side) -> new ContainerKitchenItemProvider((Container)entity){
            private final ItemStack snowStack = new ItemStack((ItemLike)Items.SNOWBALL);
            private final ItemStack iceStack = new ItemStack((ItemLike)Blocks.ICE);

            public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
                IngredientToken result = this.applyIceUnit(arg_0 -> ((Ingredient)ingredient).test(arg_0));
                if (result != null) {
                    return result;
                }
                return super.findIngredient(ingredient, ingredientTokens, cacheHint);
            }

            public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
                IngredientToken result = this.applyIceUnit(stack -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack));
                if (result != null) {
                    return result;
                }
                return super.findIngredient(itemStack, ingredientTokens, cacheHint);
            }

            @Nullable
            private IngredientToken applyIceUnit(Function<ItemStack, Boolean> predicate) {
                if (predicate.apply(this.snowStack).booleanValue()) {
                    return new FridgeBlockEntity.IceUnitIngredientToken(ContainerUtils.copyStackWithSize((ItemStack)this.snowStack, (int)64));
                }
                return predicate.apply(this.iceStack) != false ? new FridgeBlockEntity.IceUnitIngredientToken(ContainerUtils.copyStackWithSize((ItemStack)this.iceStack, (int)64)) : null;
            }
        });
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.STOVE_BLOCK_ENTITY, (entity, side) -> {
            StoveBlockEntityBalm ovenBlockEntityBalm = (StoveBlockEntityBalm)((Object)entity);
            return new ContainerKitchenItemProvider((Container)new CombinedContainer(new Container[]{ovenBlockEntityBalm.toolsContainer, ovenBlockEntityBalm.outputContainer}));
        });
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProcessor.class), BlockEntities.STOVE_BLOCK_ENTITY, (entity, side) -> (StoveBlockEntityBalm)((Object)entity));
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.DRAWER_BLOCK_ENTITY, (entity, side) -> ((GenericStorageBlockEntityBalm9x3)entity).itemProvider);
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.FRIDGE_BLOCK_ENTITY, (entity, side) -> ((FridgeBlockEntityBalm)entity).itemProvider);
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.KITCHEN_COUNTER_OVEN_BLOCK_ENTITY, (entity, side) -> ((CounterOvenBlockEntityBalm)entity).itemProvider);
        event.registerBlockEntity(((NeoForgeBalmProviders)Balm.getProviders()).getBlockCapability(KitchenItemProvider.class), BlockEntities.KITCHEN_DRAWER_SMALL_BLOCK_ENTITY, (entity, side) -> ((GenericStorageBlockEntityBalm3x3)entity).itemProvider);
    }
}

