/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge;

import com.mojang.serialization.MapCodec;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.entity.CookingTableBlockEntity;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PFMCookingTableBlock
extends BaseEntityBlock {
    MapCodec<PFMCookingTableBlock> CODEC = PFMCookingTableBlock.simpleCodec(PFMCookingTableBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)PFMCookingTableBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    protected PFMCookingTableBlock(BlockBehaviour.Properties arg) {
        super(arg);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.CODEC;
    }

    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack noFilterBook;
        ItemStack heldItem = player.getItemInHand(hand);
        CookingTableBlockEntity blockEntity = (CookingTableBlockEntity)world.getBlockEntity(pos);
        if (!heldItem.isEmpty()) {
            if (blockEntity != null && !blockEntity.hasNoFilterBook() && heldItem.getItem() == ModItems.noFilterBook) {
                blockEntity.setNoFilterBook(heldItem.split(1));
                return InteractionResult.SUCCESS;
            }
        } else if (player.isShiftKeyDown() && blockEntity != null && !(noFilterBook = blockEntity.getNoFilterBook()).isEmpty()) {
            if (!player.getInventory().add(noFilterBook)) {
                player.drop(noFilterBook, false);
            }
            blockEntity.setNoFilterBook(ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)blockEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        CookingTableBlockEntity tileEntity = (CookingTableBlockEntity)level.getBlockEntity(pos);
        if (tileEntity != null && !state.is(newState.getBlock())) {
            ItemUtils.spawnItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)tileEntity.getNoFilterBook());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CookingTableBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

