/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.recipes.FreezingRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class FreezingDisplay
implements Display {
    public static final CategoryIdentifier<FreezingDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"freezing"));
    public static final DisplaySerializer<FreezingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(FreezingDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(FreezingDisplay::getOutputEntries), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(FreezingDisplay::getDisplayLocation), (App)Codec.INT.fieldOf("cookTime").forGetter(d -> d.cookTime), (App)Codec.FLOAT.fieldOf("xp").forGetter(d -> Float.valueOf(d.xp))).apply((Applicative)instance, FreezingDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), FreezingDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), FreezingDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), FreezingDisplay::getDisplayLocation, (StreamCodec)ByteBufCodecs.INT, d -> d.cookTime, (StreamCodec)ByteBufCodecs.FLOAT, d -> Float.valueOf(d.xp), FreezingDisplay::new));
    public List<EntryIngredient> input;
    public List<EntryIngredient> output;
    public int cookTime;
    private final float xp;
    public Optional<ResourceLocation> location;

    public FreezingDisplay(RecipeHolder<FreezingRecipe> recipe) {
        this.input = Collections.singletonList(EntryIngredients.ofIngredient((Ingredient)((FreezingRecipe)recipe.value()).input()));
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)((FreezingRecipe)recipe.value()).result()));
        this.cookTime = ((FreezingRecipe)recipe.value()).cookingTime();
        this.xp = ((FreezingRecipe)recipe.value()).experience();
        this.location = Optional.of(recipe.id().location());
    }

    public FreezingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, int cookTime, float xp) {
        this.input = inputs;
        this.output = outputs;
        this.cookTime = cookTime;
        this.xp = xp;
        this.location = location;
    }

    public FreezingDisplay(FreezingRecipe freezingRecipe) {
        this.input = Collections.singletonList(EntryIngredients.ofIngredient((Ingredient)freezingRecipe.input()));
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)freezingRecipe.result()));
        this.cookTime = freezingRecipe.cookingTime();
        this.xp = freezingRecipe.experience();
        this.location = Optional.empty();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public float getXp() {
        return this.xp;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return this.location;
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

