/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FurnitureDisplay
implements Display {
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"furniture"));
    public List<EntryIngredient> input;
    public List<EntryIngredient> output;
    public Optional<ResourceLocation> location;
    public static final DisplaySerializer<FurnitureDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(FurnitureDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(FurnitureDisplay::getOutputEntries), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(FurnitureDisplay::getDisplayLocation)).apply((Applicative)instance, FurnitureDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), FurnitureDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), FurnitureDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), FurnitureDisplay::getDisplayLocation, FurnitureDisplay::new));

    public FurnitureDisplay(RecipeHolder<FurnitureRecipe> recipe) {
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)((FurnitureRecipe)recipe.value()).result()));
        this.location = Optional.of(recipe.id().location());
        List<Ingredient> ingredients = ((FurnitureRecipe)recipe.value()).getIngredients();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (Holder item : ingredient.items().toList()) {
                if (!containedItems.containsKey(item.value())) {
                    containedItems.put((Item)item.value(), 1);
                    continue;
                }
                containedItems.put((Item)item.value(), (Integer)containedItems.get(item.value()) + 1);
            }
        }
        ArrayList<ItemStack> finalList = new ArrayList<ItemStack>();
        for (Map.Entry entry : containedItems.entrySet()) {
            finalList.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        finalList.sort(Comparator.comparing(ItemStack::toString));
        ArrayList<EntryIngredient> arrayList = new ArrayList<EntryIngredient>();
        for (ItemStack stack : finalList) {
            arrayList.add(EntryIngredients.of((ItemStack)stack));
        }
        this.input = arrayList;
    }

    public FurnitureDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location) {
        this.input = input;
        this.output = output;
        this.location = location;
    }

    public FurnitureDisplay(FurnitureRecipe furnitureRecipe) {
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)furnitureRecipe.result()));
        this.location = Optional.empty();
        List<Ingredient> ingredients = furnitureRecipe.getIngredients();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (Holder item : ingredient.items().toList()) {
                if (!containedItems.containsKey(item.value())) {
                    containedItems.put((Item)item.value(), 1);
                    continue;
                }
                containedItems.put((Item)item.value(), (Integer)containedItems.get(item.value()) + 1);
            }
        }
        ArrayList<ItemStack> finalList = new ArrayList<ItemStack>();
        for (Map.Entry entry : containedItems.entrySet()) {
            finalList.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        finalList.sort(Comparator.comparing(ItemStack::toString));
        ArrayList<EntryIngredient> arrayList = new ArrayList<EntryIngredient>();
        for (ItemStack stack : finalList) {
            arrayList.add(EntryIngredients.of((ItemStack)stack));
        }
        this.input = arrayList;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return this.location;
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

