/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantBase<T>
implements StringRepresentable {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final ResourceLocation identifier;

    protected VariantBase(ResourceLocation id) {
        this.identifier = id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getTexture(BlockType var1);

    public abstract String getPath();

    public abstract Block getBaseBlock();

    public abstract Block getSecondaryBlock();

    public abstract boolean isNetherWood();

    public abstract T getVariantType();

    public abstract List<FeatureFlag> getFeatureList();

    public String getNamespace() {
        return this.identifier.getNamespace();
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public abstract boolean isVanilla();

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, Registry<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, Registry<V> reg) {
        Optional o;
        if (this.identifier.getNamespace().equals("tfc") && (o = reg.getOptional(ResourceLocation.fromNamespaceAndPath((String)this.identifier.getNamespace(), (String)("wood/" + postPend + "/" + this.identifier.getPath())))).isPresent()) {
            return (V)o.get();
        }
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        ResourceLocation[] targets = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)this.identifier.getNamespace(), (String)(this.identifier.getPath() + "_" + append + (String)post)), ResourceLocation.fromNamespaceAndPath((String)this.identifier.getNamespace(), (String)(append + "_" + this.identifier.getPath() + (String)post)), ResourceLocation.fromNamespaceAndPath((String)this.identifier.getNamespace(), (String)(this.identifier.getPath() + "_planks_" + append + (String)post))};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.containsKey(r)) continue;
            found = reg.getValue(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public Item getItemOfThis(String key) {
        Item i;
        Object v = this.getChild(key);
        return v instanceof Item ? (i = (Item)v) : null;
    }

    @Nullable
    public Block getBlockOfThis(String key) {
        Block b;
        Object v = this.getChild(key);
        return v instanceof Block ? (b = (Block)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        if (this.children.get((Object)key) != null) {
            return this.children.get((Object)key);
        }
        return this.getBaseBlock();
    }

    public void addChild(String genericName, @Nullable Object itemLike) {
        if (itemLike != null) {
            this.children.put((Object)genericName, itemLike);
            VariantRegistryBase<?> v = DynamicBlockRegistry.getBlockSet(this.getClass());
            if (v != null) {
                v.mapBlockToType(itemLike, this);
            }
        }
    }

    public abstract void initializeChildrenBlocks();

    public abstract void initializeChildrenItems();

    public abstract Block mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static Item changeItemType(Item current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        Block il;
        Item i;
        BlockItem bi;
        Object blockChanged;
        Object changed = VariantBase.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof BlockItem && (blockChanged = VariantBase.changeType((bi = (BlockItem)current).getBlock(), originalMat, destinationMat)) instanceof Block && (i = (il = (Block)blockChanged).asItem()) != Items.AIR) {
            changed = i;
        }
        if (changed instanceof Item) {
            Item il2 = (Item)changed;
            return il2.asItem();
        }
        return null;
    }

    @Nullable
    public static Block changeBlockType(@NotNull Block current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        BlockItem bi;
        Item i;
        Object itemChanged;
        Object changed = VariantBase.changeType(current, originalMat, destinationMat);
        if (changed == null && current.asItem() != Items.AIR && (itemChanged = VariantBase.changeType(current.asItem(), originalMat, destinationMat)) instanceof BlockItem && (i = (bi = (BlockItem)itemChanged).asItem()) != Items.AIR) {
            changed = i;
        }
        if (changed instanceof Block) {
            Block b = (Block)changed;
            return b;
        }
        return null;
    }

    @FunctionalInterface
    public static interface SetFinder<T extends VariantBase<T>>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

