/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.jetbrains.annotations.Nullable;

public class WoodVariantRegistry
extends VariantRegistryBase<WoodVariant> {
    public static final WoodVariant OAK = new WoodVariant(ResourceLocation.parse((String)"oak"), Blocks.OAK_PLANKS, Blocks.OAK_LOG);
    public static final WoodVariantRegistry INSTANCE = new WoodVariantRegistry();

    public static Collection<String> getNamespaces() {
        return WoodVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<WoodVariant> getVariants() {
        return Collections.unmodifiableCollection(WoodVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static WoodVariant getVariant(ResourceLocation name) {
        return WoodVariantRegistry.INSTANCE.variants.getOrDefault(name, OAK);
    }

    public static Optional<WoodVariant> getOptionalVariant(ResourceLocation name) {
        return WoodVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((WoodVariant)WoodVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Override
    public Optional<WoodVariant> getVariantFromBlock(Block baseBlock, ResourceLocation blockId) {
        BlockState state;
        String name = null;
        String path = blockId.getPath();
        if (blockId.getNamespace().equals("tfc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)path.replace("wood/planks/", ""));
                return Optional.of(new WoodVariant(id, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = blockId.getNamespace();
        if (!(namespace.equals("cozy_home") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("terrestria") && path.contains("sakura") || namespace.equals("betternether") && path.contains("nether_mushroom") || namespace.equals("chipped") || namespace.equals("regions_unexplored") && path.contains("alpha") || (state = baseBlock.defaultBlockState()).getProperties().size() > 2 || baseBlock instanceof SlabBlock)) {
            SoundType soundGroup = state.getSoundType();
            NoteBlockInstrument instrument = state.instrument();
            if (soundGroup == SoundType.BAMBOO_WOOD || soundGroup == SoundType.CHERRY_WOOD || soundGroup == SoundType.WOOD || soundGroup == SoundType.NETHER_WOOD || instrument == NoteBlockInstrument.BASS) {
                name = name.replace("/", "_");
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)name);
                Block logBlock = WoodVariantRegistry.findLog(id);
                if (logBlock != null) {
                    return Optional.of(new WoodVariant(id, baseBlock, logBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public WoodVariant getDefaultType() {
        return OAK;
    }

    @Override
    public Class<WoodVariant> getType() {
        return WoodVariant.class;
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "_log")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("log_" + id.getPath())), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "log")), ResourceLocation.parse((String)(id.getPath() + "_log")), ResourceLocation.parse((String)("log_" + id.getPath())), ResourceLocation.parse((String)(id.getPath() + "log")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "_stem")), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("stem_" + id.getPath())), ResourceLocation.parse((String)(id.getPath() + "_stem")), ResourceLocation.parse((String)("stem_" + id.getPath())), ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("stalk_" + id.getPath())), ResourceLocation.parse((String)(id.getPath() + "_stalk")), ResourceLocation.parse((String)("stalk_" + id.getPath()))};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.BLOCK.containsKey(r)) continue;
            temp = (Block)BuiltInRegistries.BLOCK.getValue(r);
            break;
        }
        return temp;
    }
}

