/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.client.PaladinFurnitureModClient;
import com.unlikepaladin.pfm.entity.neoforge.ChairEntityImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChairEntity
extends Mob {
    public ChairEntity(EntityType<? extends ChairEntity> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void fart(BlockPos pos) {
        ChairEntityImpl.fart(pos);
    }

    public void tick() {
        if (!this.isVehicle()) {
            if (!this.level().isClientSide) {
                this.discard();
            }
        } else if (this.level().getBlockState(this.blockPosition()).getBlock() instanceof BasicToiletBlock && this.level().isClientSide()) {
            if (PaladinFurnitureModClient.USE_TOILET_KEYBIND.isDown() && this.level().getBlockState(this.blockPosition()).getValue(BasicToiletBlock.TOILET_STATE) == ToiletState.CLEAN) {
                ChairEntity.fart(this.blockPosition());
            }
            super.tick();
        } else if (this.level().getBlockState(this.blockPosition()).getBlock() instanceof AbstractSittableBlock || this.level().getBlockState(this.blockPosition()).getBlock() instanceof BasicBathtubBlock) {
            super.tick();
        } else if (!this.level().isClientSide) {
            this.ejectPassengers();
            this.discard();
        }
    }

    public void aiStep() {
        super.aiStep();
        this.setDeltaMovement(Vec3.ZERO);
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public InteractionResult interactAt(Player player, Vec3 hitPos, InteractionHand hand) {
        return super.interactAt(player, hitPos, hand);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction direction = this.getMotionDirection();
        if (this.level().getBlockState(this.blockPosition()).getBlock() instanceof AbstractSittableBlock) {
            direction = ((Direction)this.level().getBlockState(this.blockPosition()).getValue((Property)AbstractSittableBlock.FACING)).getOpposite();
        }
        if (direction.getAxis() != Direction.Axis.Y) {
            int[][] dismountingOffsets = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos chairPos = this.blockPosition();
            BlockPos.MutableBlockPos dismountPos = new BlockPos.MutableBlockPos();
            for (Pose entityPose : passenger.getDismountPoses()) {
                AABB box = passenger.getLocalBoundsForPose(entityPose);
                for (int[] dismountingOffset : dismountingOffsets) {
                    dismountPos.set((double)(chairPos.getX() + dismountingOffset[0]), (double)chairPos.getY() + 0.3, (double)(chairPos.getZ() + dismountingOffset[1]));
                    double dismountHeight = this.level().getBlockFloorHeight((BlockPos)dismountPos);
                    if (!DismountHelper.isBlockFloorValid((double)dismountHeight)) continue;
                    Vec3 vec3d = Vec3.upFromBottomCenterOf((Vec3i)dismountPos, (double)dismountHeight);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)box.move(vec3d))) continue;
                    passenger.setPose(entityPose);
                    return vec3d;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 0.0);
    }

    public boolean dismountsUnderwater() {
        return false;
    }
}

