/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.level.BlockAndTintGetter;

public class MicrowaveBlockEntityRenderer<T extends MicrowaveBlockEntity>
implements BlockEntityRenderer<T> {
    public ItemStack itemStack;
    private final ItemRenderer itemRenderer;
    private RecipePropertySet recipePropertySet;

    public MicrowaveBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        float y;
        float x;
        this.itemStack = ((MicrowaveBlockEntity)((Object)blockEntity)).getItem(0);
        matrices.pushPose();
        if (this.recipePropertySet == null) {
            this.recipePropertySet = blockEntity.getLevel().recipeAccess().propertySet(RecipePropertySet.SMOKER_INPUT);
        }
        int lightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above());
        Direction facing = ((MicrowaveBlockEntity)((Object)blockEntity)).getFacing();
        matrices.translate(x, y, switch (facing) {
            case Direction.NORTH -> {
                x = 0.625f;
                y = 0.25f;
                yield 0.57f;
            }
            case Direction.SOUTH -> {
                x = 0.375f;
                y = 0.25f;
                yield 0.43f;
            }
            case Direction.WEST -> {
                x = 0.57f;
                y = 0.25f;
                yield 0.375f;
            }
            case Direction.EAST -> {
                x = 0.43f;
                y = 0.25f;
                yield 0.625f;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
        });
        matrices.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        if (((MicrowaveBlockEntity)((Object)blockEntity)).isActive && this.recipePropertySet.test(this.itemStack)) {
            matrices.mulPose(Axis.YP.rotationDegrees(((float)blockEntity.getLevel().getGameTime() + tickDelta) * 4.0f));
        }
        matrices.scale(0.5f, 0.5f, 0.5f);
        this.itemRenderer.renderStatic(this.itemStack, ItemDisplayContext.GROUND, lightAbove, overlay, matrices, vertexConsumers, blockEntity.getLevel(), 0);
        matrices.popPose();
    }
}

