/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.unlikepaladin.pfm.blocks.PlateBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PlateBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;

public class PlateBlockEntityRenderer<T extends PlateBlockEntity>
implements BlockEntityRenderer<T> {
    public ItemStack itemStack;
    private static final float SCALE = 0.375f;
    private final ItemRenderer itemRenderer;

    public PlateBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(PlateBlockEntity plateBlockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        Direction direction = (Direction)plateBlockEntity.getBlockState().getValue((Property)PlateBlock.FACING);
        this.itemStack = plateBlockEntity.getItemInPlate();
        matrices.pushPose();
        Direction direction2 = Direction.from2DDataValue((int)(direction.get2DDataValue() % 4));
        float g = -direction2.toYRot();
        Direction dir = (Direction)plateBlockEntity.getBlockState().getValue((Property)PlateBlock.FACING);
        switch (dir) {
            case NORTH: {
                matrices.translate(0.5, 0.08, 0.65);
                break;
            }
            case SOUTH: {
                matrices.translate(0.5, 0.08, 0.35);
                break;
            }
            case WEST: {
                matrices.translate(0.65, 0.08, 0.5);
                break;
            }
            case EAST: {
                matrices.translate(0.35, 0.08, 0.5);
            }
        }
        int rot = 90;
        matrices.mulPose(Axis.YP.rotationDegrees(g));
        matrices.mulPose(Axis.XP.rotationDegrees((float)rot));
        if (BuiltInRegistries.ITEM.getKey((Object)this.itemStack.getItem()).toString().equals("sandwichable:sandwich")) {
            matrices.mulPose(Axis.XP.rotationDegrees(270.0f));
            matrices.translate(0.0, 0.11, 0.05);
        }
        int lightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)plateBlockEntity.getLevel(), (BlockPos)plateBlockEntity.getBlockPos().above());
        this.itemRenderer.renderStatic(this.itemStack, ItemDisplayContext.GROUND, lightAbove, OverlayTexture.NO_OVERLAY, matrices, vertexConsumerProvider, plateBlockEntity.getLevel(), 0);
        matrices.popPose();
    }
}

