/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.items;

import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LightSwitchItem
extends BlockItem {
    private Block block;

    public LightSwitchItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.block = block;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
            LightSwitchItem.createTag(stack);
            return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof PowerableBlock) {
            if (block instanceof PendantBlock) {
                boolean isRoot;
                boolean isSingle = (Boolean)state.getValue((Property)PendantBlock.DOWN) == false && (Boolean)state.getValue((Property)PendantBlock.UP) == false;
                boolean bl = isRoot = (Boolean)state.getValue((Property)PendantBlock.DOWN) != false && (Boolean)state.getValue((Property)PendantBlock.UP) == false;
                if (isSingle || isRoot) {
                    this.addLight(context.getItemInHand(), pos);
                } else if (context.getLevel().isClientSide) {
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.pfm.light_switch_not_canopy"), false);
                }
            } else {
                this.addLight(context.getItemInHand(), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        boolean canPlace;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Direction side = context.getClickedFace();
        ListTag lights = LightSwitchItem.getLights(context.getItemInHand());
        boolean bl = canPlace = state.canSurvive((LevelReader)world, pos) && side.getAxis().isHorizontal();
        if (!canPlace) {
            return false;
        }
        if (lights != null) {
            ArrayList<BlockPos> removedLights = new ArrayList<BlockPos>();
            ArrayList<BlockPos> lightOffsets = new ArrayList<BlockPos>();
            Iterator iterator = lights.iterator();
            while (iterator.hasNext()) {
                Tag nbtElement = (Tag)iterator.next();
                BlockPos lightPos = BlockPos.of((long)((LongTag)nbtElement).getAsLong());
                double distance = Math.sqrt(lightPos.distToLowCornerSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
                if (distance > 16.0) {
                    removedLights.add(BlockPos.of((long)((LongTag)nbtElement).getAsLong()));
                    iterator.remove();
                    continue;
                }
                lightOffsets.add(pos.subtract((Vec3i)lightPos));
            }
            context.getItemInHand().remove(DataComponents.BLOCK_ENTITY_DATA);
            LightSwitchItem.createTag(context.getItemInHand());
            for (BlockPos blockPos : lightOffsets) {
                this.addLight(context.getItemInHand(), blockPos);
            }
            if (!removedLights.isEmpty() && context.getLevel().isClientSide) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.pfm.light_switch_far", (Object[])new Object[]{removedLights.toString()}), false);
            }
        }
        return true;
    }

    private void addLight(ItemStack stack, BlockPos pos) {
        ListTag tagList;
        CompoundTag nbtCompound = LightSwitchItem.createTag(stack);
        if (!nbtCompound.contains("lights", 9)) {
            nbtCompound.put("lights", (Tag)new ListTag());
        }
        if (!this.containsLight(tagList = (ListTag)nbtCompound.get("lights"), pos)) {
            tagList.add((Object)LongTag.valueOf((long)pos.asLong()));
        }
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
    }

    private boolean containsLight(ListTag tagList, BlockPos pos) {
        for (int i = 0; i < tagList.size(); ++i) {
            LongTag tagLong = (LongTag)tagList.get(i);
            if (tagLong.getAsLong() != pos.asLong()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ListTag getLights(ItemStack stack) {
        CompoundTag blockEntityTag;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (blockEntityTag = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe()).contains("lights", 9)) {
            return (ListTag)blockEntityTag.get("lights");
        }
        return null;
    }

    private static CompoundTag createTag(ItemStack stack) {
        if (!stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.putString("id", "pfm:light_switch_block_entity");
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
        }
        return ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ListTag nbtList;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (nbtList = LightSwitchItem.getLights(stack)) != null) {
            int lightNum = nbtList.size();
            tooltip.add((Component)Component.translatable((String)"tooltip.pfm.light_switch_connected", (Object[])new Object[]{lightNum}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

