/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.unlikepaladin.pfm.blocks.blockentities.FreezerBlockEntity;
import com.unlikepaladin.pfm.fabric.menus.slots.GenericOutputSlot;
import com.unlikepaladin.pfm.menus.slots.FreezerFuelSlot;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public abstract class AbstractFreezerScreenHandler
extends RecipeBookMenu {
    private final Container inventory;
    private final ContainerData propertyDelegate;
    protected final Level world;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeBookType category;
    private final RecipePropertySet recipePropertySet;

    protected AbstractFreezerScreenHandler(MenuType<?> type, RecipeType<? extends AbstractCookingRecipe> recipeType, RecipeBookType category, int syncId, Inventory playerInventory) {
        this(type, recipeType, category, syncId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    protected AbstractFreezerScreenHandler(MenuType<?> type, RecipeType<? extends AbstractCookingRecipe> recipeType, RecipeBookType category, int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super(type, syncId);
        int i;
        this.recipeType = recipeType;
        this.category = category;
        AbstractFreezerScreenHandler.checkContainerSize((Container)inventory, (int)3);
        AbstractFreezerScreenHandler.checkContainerDataCount((ContainerData)propertyDelegate, (int)4);
        this.inventory = inventory;
        inventory.startOpen(playerInventory.player);
        this.propertyDelegate = propertyDelegate;
        this.world = playerInventory.player.getCommandSenderWorld();
        this.recipePropertySet = this.world.recipeAccess().propertySet(RecipeTypes.FREEZING_INPUT);
        this.addSlot(new Slot(inventory, 0, 56, 17));
        this.addSlot(new FreezerFuelSlot(this, inventory, 1, 56, 53));
        this.addSlot(new GenericOutputSlot(playerInventory.player, inventory, 2, 116, 35, 0));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(propertyDelegate);
    }

    public void fillCraftSlotsStackedContents(StackedItemContents finder) {
        if (this.inventory instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.inventory).fillStackedContents(finder);
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2 != null && slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot == 2) {
                if (!this.moveItemStackTo(itemStack2, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onQuickCraft(itemStack2, itemStack);
            } else if (slot != 1 && slot != 0 ? (this.isFreezeable(itemStack2) ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (this.isFuel(itemStack2) ? !this.moveItemStackTo(itemStack2, 1, 2, false) : (slot >= 3 && slot < 30 ? !this.moveItemStackTo(itemStack2, 30, 39, false) : slot >= 30 && slot < 39 && !this.moveItemStackTo(itemStack2, 3, 30, false)))) : !this.moveItemStackTo(itemStack2, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot2.onTake(player, itemStack2);
        }
        return itemStack;
    }

    protected boolean isFreezeable(ItemStack itemStack) {
        return this.recipePropertySet.test(itemStack);
    }

    public boolean isFuel(ItemStack itemStack) {
        return FreezerBlockEntity.canUseAsFuel(itemStack);
    }

    public int getFreezeProgress() {
        int i = this.propertyDelegate.get(2);
        int j = this.propertyDelegate.get(3);
        if (j == 0 || i == 0) {
            return 0;
        }
        return i * 24 / j;
    }

    public int getFuelProgress() {
        int i = this.propertyDelegate.get(1);
        if (i == 0) {
            i = 200;
        }
        return this.propertyDelegate.get(0) * 13 / i;
    }

    public boolean isActive() {
        return this.propertyDelegate.get(0) > 0;
    }

    public RecipeBookType getRecipeBookType() {
        return this.category;
    }

    public boolean canDragTo(Slot slot) {
        return slot.index != 1;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.index != 1;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean craftAll, boolean creative, RecipeHolder<?> recipe, final ServerLevel world, Inventory inventory) {
        final List<Slot> list = List.of(this.getSlot(0), this.getSlot(2));
        RecipeHolder<?> recipeEntry = recipe;
        return ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)new ServerPlaceRecipe.CraftingMenuAccess<AbstractCookingRecipe>(){

            public void fillCraftSlotsStackedContents(StackedItemContents finder) {
                AbstractFreezerScreenHandler.this.fillCraftSlotsStackedContents(finder);
            }

            public void clearCraftingContent() {
                list.forEach(slot -> slot.set(ItemStack.EMPTY));
            }

            public boolean recipeMatches(RecipeHolder<AbstractCookingRecipe> entry) {
                return ((AbstractCookingRecipe)entry.value()).matches(new SingleRecipeInput(AbstractFreezerScreenHandler.this.inventory.getItem(0)), (Level)world);
            }
        }, (int)1, (int)1, List.of(this.getSlot(0)), list, (Inventory)inventory, recipeEntry, (boolean)craftAll, (boolean)creative);
    }
}

