/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.unlikepaladin.pfm.blocks.blockentities.TrashcanBlockEntity;
import com.unlikepaladin.pfm.menus.neoforge.TrashcanScreenHandlerImpl;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TrashcanScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    protected final Level world;
    public TrashcanBlockEntity trashcanBlockEntity;
    public static final StreamCodec<RegistryFriendlyByteBuf, TrashCanData> PACKET_CODEC = StreamCodec.ofMember(TrashCanData::write, TrashCanData::new);

    public TrashcanScreenHandler(int syncId, Inventory playerInventory, TrashCanData canData) {
        this(null, syncId, playerInventory, (Container)new SimpleContainer(9));
        this.trashcanBlockEntity = (TrashcanBlockEntity)this.world.getBlockEntity(canData.pos());
    }

    public TrashcanScreenHandler(TrashcanBlockEntity trashcanBlockEntity, int syncId, Inventory playerInventory, Container inventory) {
        super(ScreenHandlerIDs.TRASHCAN_SCREEN_HANDLER, syncId);
        int j;
        int i;
        this.trashcanBlockEntity = trashcanBlockEntity;
        TrashcanScreenHandler.checkContainerSize((Container)inventory, (int)9);
        this.inventory = inventory;
        this.world = playerInventory.player.level();
        inventory.startOpen(playerInventory.player);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new Slot(inventory, j + i * 3, 62 + j * 18, 17 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void clear(TrashcanBlockEntity trashcanBlockEntity) {
        TrashcanScreenHandlerImpl.clear(trashcanBlockEntity);
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 9 ? !this.moveItemStackTo(itemStack2, 9, 45, true) : !this.moveItemStackTo(itemStack2, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public record TrashCanData(BlockPos pos) {
        public TrashCanData(RegistryFriendlyByteBuf buf) {
            this(buf.readBlockPos());
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeBlockPos(this.pos);
        }
    }
}

