/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.unlikepaladin.pfm.client.ColorRegistry;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.mixin.BasicItemModelAccessor;
import com.unlikepaladin.pfm.mixin.CompositeItemModelAccessor;
import com.unlikepaladin.pfm.mixin.ConditionItemModelAccessor;
import com.unlikepaladin.pfm.mixin.RangeDispatchItemModelAccessor;
import com.unlikepaladin.pfm.mixin.SelectItemModelAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockModelWrapper.class})
public class BasicItemModelMixin {
    @Unique
    private ItemStack pfm$parentStack = ItemStack.EMPTY;
    @Unique
    private List<ItemTintSource> pfm$parentTints;

    @Inject(method={"update(Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/item/ItemModelResolver;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="HEAD", target="Lnet/minecraft/client/renderer/item/ItemStackRenderState$LayerRenderState;prepareTintLayers(I)[I")})
    private void inject(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext transformationMode, ClientLevel world, LivingEntity user, int seed, CallbackInfo ci) {
        ItemModel parentModel;
        ResourceLocation parentModelId;
        Item item;
        if (ColorRegistry.itemColorProviders.containsKey(stack.getItem()) && this.pfm$parentTints == null) {
            item = ColorRegistry.itemColorProviders.get(stack.getItem()).asItem();
            parentModelId = (ResourceLocation)item.getDefaultInstance().get(DataComponents.ITEM_MODEL);
            parentModel = Minecraft.getInstance().getModelManager().getItemModel(parentModelId);
            this.pfm$parentStack = item.getDefaultInstance();
            this.pfm$parentTints = this.exploreForTints(parentModel, world, user, seed, transformationMode);
        }
        if (stack.has(PFMComponents.VARIANT_COMPONENT)) {
            item = WoodVariantRegistry.getVariant((ResourceLocation)stack.get(PFMComponents.VARIANT_COMPONENT)).getLogBlock().asItem();
            parentModelId = (ResourceLocation)item.getDefaultInstance().get(DataComponents.ITEM_MODEL);
            parentModel = Minecraft.getInstance().getModelManager().getItemModel(parentModelId);
            this.pfm$parentStack = item.getDefaultInstance();
            this.pfm$parentTints = this.exploreForTints(parentModel, world, user, seed, transformationMode);
        }
    }

    @Unique
    private List<ItemTintSource> exploreForTints(ItemModel model, ClientLevel world, LivingEntity user, int seed, ItemDisplayContext transformationMode) {
        ItemModel itemModel = model;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasicItemModelAccessor.class, CompositeItemModelAccessor.class, ConditionItemModelAccessor.class, SelectItemModelAccessor.class, RangeDispatchItemModelAccessor.class}, (Object)itemModel, n)) {
            case 0: {
                BasicItemModelAccessor accessor = (BasicItemModelAccessor)itemModel;
                return accessor.getTints();
            }
            case 1: {
                CompositeItemModelAccessor accessor = (CompositeItemModelAccessor)itemModel;
                for (ItemModel itemModel2 : accessor.getItemModels()) {
                    List<ItemTintSource> src = this.exploreForTints(itemModel2, world, user, seed, transformationMode);
                    if (src.isEmpty()) continue;
                    return src;
                }
                break;
            }
            case 2: {
                ConditionItemModelAccessor accessor = (ConditionItemModelAccessor)itemModel;
                boolean property = accessor.getProperty().get(this.pfm$parentStack, world, user, seed, transformationMode);
                if (property) {
                    return this.exploreForTints(accessor.getOnTrue(), world, user, seed, transformationMode);
                }
                return this.exploreForTints(accessor.getOnFalse(), world, user, seed, transformationMode);
            }
            case 3: {
                SelectItemModelAccessor accessor = (SelectItemModelAccessor)itemModel;
                ItemModel itemModel3 = (ItemModel)accessor.getModels().get(accessor.getProperty().get(this.pfm$parentStack, world, user, seed, transformationMode));
                return this.exploreForTints(itemModel3, world, user, seed, transformationMode);
            }
            case 4: {
                int i;
                RangeDispatchItemModelAccessor accessor = (RangeDispatchItemModelAccessor)itemModel;
                float select = accessor.getProperty().get(this.pfm$parentStack, world, user, seed) * accessor.getScale();
                ItemModel itemModel4 = Float.isNaN(select) ? accessor.getFallback() : ((i = RangeDispatchItemModelAccessor.getIndex(accessor.getThresholds(), select)) == -1 ? accessor.getFallback() : accessor.getModels()[i]);
                return this.exploreForTints(itemModel4, world, user, seed, transformationMode);
            }
            default: {
                return List.of();
            }
        }
        return List.of();
    }

    @WrapOperation(method={"update(Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/item/ItemModelResolver;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Ljava/util/List;get(I)Ljava/lang/Object;")})
    private <E> E swapTintIndx(List instance, int i, Operation<ItemTintSource> original, @Share(value="currentColorIndex") LocalIntRef currentColorIndex) {
        currentColorIndex.set(i);
        if (this.pfm$parentTints != null) {
            return (E)this.pfm$parentTints.get(i);
        }
        return (E)original.call(new Object[]{instance, i});
    }

    @WrapOperation(method={"update(Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/item/ItemModelResolver;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/color/item/ItemTintSource;calculate(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int swapTintColor(ItemTintSource instance, ItemStack itemStack, ClientLevel clientWorld, LivingEntity livingEntity, Operation<Integer> original, @Share(value="currentColorIndex") LocalIntRef currentColorIndex) {
        if (currentColorIndex.get() == 1 && itemStack.has(PFMComponents.COLOR_COMPONENT)) {
            return ((DyeColor)itemStack.getOrDefault(PFMComponents.COLOR_COMPONENT, (Object)DyeColor.WHITE)).getMapColor().col;
        }
        if (this.pfm$parentTints != null) {
            return this.pfm$parentTints.get(currentColorIndex.get()).calculate(this.pfm$parentStack, clientWorld, livingEntity);
        }
        return (Integer)original.call(new Object[]{instance, itemStack, clientWorld, livingEntity});
    }
}

