/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.mixin.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import com.unlikepaladin.pfm.client.model.PFMBakedModelGetQuadsExtension;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    public static VertexConsumer getFoilBuffer(MultiBufferSource vertexConsumers, RenderType layer, boolean solid, boolean glint) {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private static VertexConsumer getCompassFoilBuffer(MultiBufferSource provider, RenderType layer, PoseStack.Pose entry) {
        return null;
    }

    @Shadow
    private static void renderQuadList(PoseStack matrices, VertexConsumer vertexConsumer, List<BakedQuad> quads, int[] tints, int light, int overlay) {
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II[ILnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/item/ItemStackRenderState$FoilType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderPFMItem(ItemDisplayContext transformationMode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, int[] tints, BakedModel model, RenderType layer, ItemStackRenderState.FoilType glint, CallbackInfo ci) {
        if (model instanceof PFMBakedModelGetQuadsExtension) {
            VertexConsumer vertexconsumer;
            if (glint == ItemStackRenderState.FoilType.SPECIAL) {
                PoseStack.Pose posestack$pose = matrices.last().copy();
                if (transformationMode == ItemDisplayContext.GUI) {
                    MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.5f);
                } else if (transformationMode.firstPerson()) {
                    MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.75f);
                }
                vertexconsumer = ItemRendererMixin.getCompassFoilBuffer(vertexConsumers, layer, posestack$pose);
            } else {
                vertexconsumer = ItemRendererMixin.getFoilBuffer(vertexConsumers, layer, true, glint != ItemStackRenderState.FoilType.NONE);
            }
            RandomSource randomsource = RandomSource.create();
            long seed = 42L;
            for (Direction direction : Direction.values()) {
                randomsource.setSeed(seed);
                ItemRendererMixin.renderQuadList(matrices, vertexconsumer, ((PFMBakedModelGetQuadsExtension)model).getQuadsCached(direction, randomsource), tints, light, overlay);
            }
            randomsource.setSeed(seed);
            ItemRendererMixin.renderQuadList(matrices, vertexconsumer, ((PFMBakedModelGetQuadsExtension)model).getQuadsCached(null, randomsource), tints, light, overlay);
            ci.cancel();
        }
    }
}

