/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking;

import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import com.unlikepaladin.pfm.client.screens.MicrowaveScreen;
import com.unlikepaladin.pfm.menus.MicrowaveScreenHandler;
import com.unlikepaladin.pfm.registry.NetworkIDs;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record MicrowaveUpdatePayload(BlockPos pos, Boolean isActive) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, MicrowaveUpdatePayload> PACKET_CODEC = CustomPacketPayload.codec(MicrowaveUpdatePayload::write, MicrowaveUpdatePayload::new);
    public static final StreamCodec<FriendlyByteBuf, MicrowaveUpdatePayload> PACKET_SIMPLE_CODEC = CustomPacketPayload.codec(MicrowaveUpdatePayload::write, MicrowaveUpdatePayload::new);

    public MicrowaveUpdatePayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean());
    }

    public MicrowaveUpdatePayload(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkIDs.MICROWAVE_UPDATE_PACKET_ID;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.isActive.booleanValue());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.isActive.booleanValue());
    }

    public void handle(Player player, Minecraft client) {
        if (player.level().hasChunkAt(this.pos)) {
            client.execute(() -> {
                Screen patt0$temp;
                MicrowaveBlockEntity blockEntity = (MicrowaveBlockEntity)player.level().getBlockEntity(this.pos);
                if (Objects.nonNull(client.screen) && (patt0$temp = client.screen) instanceof MicrowaveScreen) {
                    MicrowaveScreen currentScreen = (MicrowaveScreen)patt0$temp;
                    MicrowaveScreenHandler cfr_ignored_0 = (MicrowaveScreenHandler)currentScreen.getMenu();
                    MicrowaveScreenHandler.setActive(blockEntity, this.isActive);
                }
            });
        } else {
            client.player.displayClientMessage(Component.nullToEmpty((String)"Trying to access unloaded chunks, are you cheating?"), false);
        }
    }
}

