/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FurnitureRecipe
implements Recipe<FurnitureRecipeInput>,
Comparable<FurnitureRecipe> {
    final String group;
    protected final ItemStack output;
    final NonNullList<Ingredient> input;

    public FurnitureRecipe(String group, ItemStack output, NonNullList<Ingredient> input) {
        this.group = group;
        this.output = output;
        this.input = input;
    }

    public Map<Item, Integer> getItemCounts() {
        HashMap<Item, Integer> ingredientCounts = new HashMap<Item, Integer>();
        for (Ingredient ingredient : this.getIngredients()) {
            for (Holder itemRegistryEntry : ingredient.items().toList()) {
                if (ingredientCounts.containsKey(itemRegistryEntry.value())) {
                    ingredientCounts.put((Item)itemRegistryEntry.value(), (Integer)ingredientCounts.get(itemRegistryEntry.value()) + 1);
                    continue;
                }
                ingredientCounts.put((Item)itemRegistryEntry.value(), 1);
            }
        }
        return ingredientCounts;
    }

    public boolean matches(FurnitureRecipeInput playerInventory, Level world) {
        Map<Item, Integer> ingredientCounts = this.getItemCounts();
        for (Map.Entry<Item, Integer> entry : ingredientCounts.entrySet()) {
            Item item = entry.getKey();
            Integer count = entry.getValue();
            int itemCount = 0;
            ItemStack defaultStack = item.getDefaultInstance();
            for (ItemStack stack1 : playerInventory.playerInventory().items) {
                if (!defaultStack.is(stack1.getItem())) continue;
                itemCount += stack1.getCount();
            }
            if (itemCount >= count) continue;
            return false;
        }
        return true;
    }

    public List<Ingredient> getIngredients() {
        return this.input;
    }

    public static int getSlotWithStackIgnoreNBT(Inventory inventory, Item item) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty() || item != ((ItemStack)inventory.items.get(i)).getItem()) continue;
            return i;
        }
        return -1;
    }

    public ItemStack craft(FurnitureRecipeInput inventory, HolderLookup.Provider lookup) {
        if (!this.output.getComponents().isEmpty() && this.output.has(DataComponents.BLOCK_ENTITY_DATA) && ((CustomData)this.output.get(DataComponents.BLOCK_ENTITY_DATA)).isEmpty()) {
            ItemStack stack = this.output.copy();
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
            return stack;
        }
        return this.output.copy();
    }

    public String group() {
        return this.group;
    }

    public RecipeSerializer<? extends Recipe<FurnitureRecipeInput>> getSerializer() {
        return RecipeTypes.FURNITURE_SERIALIZER;
    }

    public RecipeType<? extends Recipe<FurnitureRecipeInput>> getType() {
        return RecipeTypes.FURNITURE_RECIPE;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.createFromOptionals(this.input.stream().map(Optional::of).toList());
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    @Override
    public int compareTo(@NotNull FurnitureRecipe furnitureRecipe) {
        return this.output.toString().compareTo(furnitureRecipe.output.toString());
    }

    public ItemStack result() {
        return this.output;
    }

    public boolean enabled(Level world) {
        if (!this.output.isItemEnabled(world.enabledFeatures())) {
            return false;
        }
        for (Ingredient ingredient : this.getIngredients()) {
            for (Holder item : ingredient.items().toList()) {
                if (((Item)item.value()).isEnabled(world.enabledFeatures())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpecial() {
        return true;
    }

    public record FurnitureRecipeInput(Inventory playerInventory) implements RecipeInput
    {
        public ItemStack getItem(int slot) {
            return this.playerInventory.getItem(slot);
        }

        public int size() {
            return this.playerInventory.getContainerSize();
        }

        public boolean isEmpty() {
            return this.playerInventory.isEmpty();
        }
    }

    public static class Serializer
    implements RecipeSerializer<FurnitureRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, FurnitureRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);
        public static final MapCodec<FurnitureRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(FurnitureRecipe::group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            NonNullList defaultedList = NonNullList.create();
            defaultedList.addAll((Collection)ingredients);
            if (defaultedList.isEmpty()) {
                return DataResult.error(() -> "No ingredients for furniture recipe");
            }
            return DataResult.success((Object)defaultedList);
        }, DataResult::success).forGetter(furnitureRecipe -> furnitureRecipe.input)).apply((Applicative)instance, FurnitureRecipe::new));

        public static FurnitureRecipe read(RegistryFriendlyByteBuf packetByteBuf) {
            String string = packetByteBuf.readUtf();
            NonNullList defaultedList = (NonNullList)packetByteBuf.readCollection(NonNullList::createWithCapacity, buf1 -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf1)));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetByteBuf);
            return new FurnitureRecipe(string, itemStack, (NonNullList<Ingredient>)defaultedList);
        }

        public MapCodec<FurnitureRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FurnitureRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        public static void write(RegistryFriendlyByteBuf packetByteBuf, FurnitureRecipe furnitureRecipe) {
            packetByteBuf.writeUtf(furnitureRecipe.group);
            packetByteBuf.writeCollection(furnitureRecipe.input, (buff, ingredient) -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buff), ingredient));
            ItemStack.STREAM_CODEC.encode((Object)packetByteBuf, (Object)furnitureRecipe.output);
        }
    }
}

