/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic;

import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class FurnitureEntry<T extends Block> {
    private final HashMap<VariantBase<?>, Set<T>> variantToBlockMapList = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMap = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMapNonBase = new LinkedHashMap();
    final List<T> allBlocks = new ArrayList<T>();
    private Class<T> type;

    public <J extends Block> void addBlock(VariantBase variantBase, J block1, boolean base) {
        J block;
        if (block1 != null) {
            block = block1;
            if (base) {
                this.variantToBlockMap.put(variantBase, block);
            } else {
                this.variantToBlockMapNonBase.put(variantBase, block);
            }
            if (!this.variantToBlockMapList.containsKey(variantBase)) {
                this.variantToBlockMapList.put(variantBase, new HashSet());
            }
        } else {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.variantToBlockMapList.get(variantBase).add(block);
        this.allBlocks.add(block);
        this.type = block1.getClass();
    }

    public Optional<Block> getEntryFromVariant(VariantBase<?> variant) {
        if (this.variantToBlockMap.containsKey(variant)) {
            return Optional.of((Block)this.variantToBlockMap.get(variant));
        }
        if (this.variantToBlockMapNonBase.containsKey(variant)) {
            return Optional.of((Block)this.variantToBlockMapNonBase.get(variant));
        }
        return Optional.empty();
    }

    public VariantBase<?> getVariantFromEntry(Block block) {
        if (block.getClass() == this.getTClass()) {
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMap.entrySet()) {
                if (!((Block)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMapNonBase.entrySet()) {
                if (!((Block)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, Object> entry : this.variantToBlockMapList.entrySet()) {
                if (!((Set)entry.getValue()).contains(block)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void addBlock(T block) {
        if (block == null) {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.allBlocks.add(block);
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMap() {
        return this.variantToBlockMap;
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMapNonBase() {
        return this.variantToBlockMapNonBase;
    }

    public Optional<T> getFromIdentifier(ResourceLocation identifier, boolean base) {
        if (base) {
            for (VariantBase<?> variantBase : this.variantToBlockMap.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((Block)this.variantToBlockMap.get(variantBase));
            }
        } else {
            for (VariantBase<?> variantBase : this.variantToBlockMapNonBase.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((Block)this.variantToBlockMapNonBase.get(variantBase));
            }
        }
        for (Block block : this.allBlocks) {
            if (!block.getDescriptionId().contains(identifier.getPath())) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public HashMap<VariantBase<?>, Set<T>> getVariantToBlockMapList() {
        return this.variantToBlockMapList;
    }

    public List<T> getAllBlocks() {
        return this.allBlocks;
    }

    public Class<T> getTClass() {
        return this.type;
    }
}

