/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.neoforge;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.compat.cookingforblockheads.neoforge.PFMCookingForBlockHeadsCompat;
import com.unlikepaladin.pfm.items.neoforge.FurnitureGuideBookImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.BlockItemRegistry;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.dynamic.LateBlockRegistry;
import com.unlikepaladin.pfm.registry.neoforge.BlockItemRegistryImpl;
import java.util.LinkedHashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.wrapper.ForwardingItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="pfm", bus=EventBusSubscriber.Bus.MOD)
public class BlockItemRegistryNeoForge {
    @SubscribeEvent
    public static void registerBlocks(RegisterEvent event) {
        event.register(BuiltInRegistries.BLOCK.key(), blockRegisterHelper -> {
            BlockItemRegistry.registerCommonBlocks();
            BlockItemRegistryImpl.blocks.forEach((blockName, block) -> blockRegisterHelper.register(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)blockName), block));
        });
    }

    @SubscribeEvent
    public static void registerItems(RegisterEvent event) {
        event.register(BuiltInRegistries.ITEM.key(), itemRegisterHelper -> {
            if (!PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.containsKey(PaladinFurnitureMod.FURNITURE_GROUP)) {
                PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.put(PaladinFurnitureMod.FURNITURE_GROUP, new LinkedHashSet());
            }
            PaladinFurnitureModBlocksItems.FURNITURE_BOOK = new FurnitureGuideBookImpl(new Item.Properties().rarity(Rarity.RARE).stacksTo(1).setId(LateBlockRegistry.getItemRegistryKey("furniture_book")));
            PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.get(PaladinFurnitureMod.FURNITURE_GROUP).add(PaladinFurnitureModBlocksItems.FURNITURE_BOOK);
            BlockItemRegistry.registerCommonItems();
            BlockItemRegistryImpl.items.forEach((itemName, itemSupplier) -> {
                Item item = (Item)itemSupplier.get();
                if (!PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.containsKey(BlockItemRegistryImpl.itemNameToGroup.get(itemName))) {
                    PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.put(BlockItemRegistryImpl.itemNameToGroup.get(itemName), new LinkedHashSet());
                }
                PaladinFurnitureModBlocksItems.ITEM_GROUP_LIST_MAP.get(BlockItemRegistryImpl.itemNameToGroup.get(itemName)).add(item);
                itemRegisterHelper.register(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)itemName), (Object)item);
            });
        });
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntities.FREEZER_BLOCK_ENTITY, (freezerBlockEntity, side) -> {
            if (side == null) {
                return new ForwardingItemHandler(() -> new InvWrapper((Container)freezerBlockEntity));
            }
            return new ForwardingItemHandler(() -> new SidedInvWrapper((WorldlyContainer)freezerBlockEntity, side));
        });
        if (ModList.get().isLoaded("cookingforblockheads")) {
            PFMCookingForBlockHeadsCompat.registerCapabilities(event);
        }
    }
}

