/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.google.common.base.Stopwatch;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.runtime.data.PFMLootTableProvider;
import com.unlikepaladin.pfm.runtime.data.PFMMCMetaProvider;
import com.unlikepaladin.pfm.runtime.data.PFMRecipeProvider;
import com.unlikepaladin.pfm.runtime.data.PFMTagProvider;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.apache.logging.log4j.LogManager;

public class PFMDataGenerator
extends PFMGenerator {
    public static boolean FROZEN = false;
    private int count = 4;
    private String progress;

    public PFMDataGenerator(Path output, boolean logOrDebug) {
        super(output, logOrDebug, LogManager.getLogger((String)"PFM-DataGen"));
    }

    @Override
    public void run() throws IOException {
        if (!FROZEN) {
            this.count = 0;
            PFMDataGenerator.setDataRunning(true);
            this.log("Packs:");
            for (PackResources pack : PFMRuntimeResources.RESOURCE_PACK_LIST) {
                this.log("\tPack {} {}", pack.location().title().getString().replace("Pack Fabric Mod ", "").replaceAll("\"", ""));
                for (String namespace : pack.getNamespaces(PackType.SERVER_DATA)) {
                    this.log("\t\tNamespace {} {}", namespace);
                }
            }
            FROZEN = true;
            Path modListPath = this.output.resolve("modsList");
            Path hashPath = this.output.resolve("dataHash");
            if (!modListPath.toFile().isFile()) {
                Files.deleteIfExists(modListPath);
                Files.createFile(modListPath, new FileAttribute[0]);
            }
            if (!hashPath.toFile().isFile()) {
                Files.deleteIfExists(hashPath);
                Files.createFile(hashPath, new FileAttribute[0]);
            }
            List<String> hashToCompare = this.hashDirectory(this.output.toFile(), false);
            List<String> oldHash = Files.readAllLines(hashPath);
            List<String> modList = Files.readAllLines(modListPath);
            if (!hashToCompare.toString().equals(oldHash.toString()) || !modList.toString().replace("[", "").replace("]", "").equals(PaladinFurnitureMod.getVersionMap().toString())) {
                ArrayList<PFMProvider> dataProviders = new ArrayList<PFMProvider>();
                dataProviders.add(new PFMMCMetaProvider(this, PackType.SERVER_DATA, "PFM-Data"));
                dataProviders.add(new PFMTagProvider(this));
                dataProviders.add(new PFMLootTableProvider(this));
                dataProviders.add(new PFMRecipeProvider(this));
                this.getLogger().info("Starting PFM Data Generation");
                PFMFileUtil.deleteDir(this.output.toFile());
                Stopwatch stopwatch = Stopwatch.createStarted();
                Stopwatch stopwatch2 = Stopwatch.createUnstarted();
                for (DataProvider dataProvider : dataProviders) {
                    this.log("Starting provider: {}", dataProvider.getName());
                    stopwatch2.start();
                    dataProvider.run(null);
                    stopwatch2.stop();
                    ++this.count;
                    this.log("{} finished after {} ms", dataProvider.getName(), stopwatch2.elapsed(TimeUnit.MILLISECONDS));
                    stopwatch2.reset();
                }
                this.getLogger().info("Data providers took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                Files.deleteIfExists(hashPath);
                Files.createFile(hashPath, new FileAttribute[0]);
                List<String> newDataHash = this.hashDirectory(this.output.toFile(), false);
                Files.writeString(PFMRuntimeResources.createDirIfNeeded(hashPath), (CharSequence)newDataHash.toString().replace("[", "").replace("]", ""), StandardOpenOption.APPEND);
                Files.deleteIfExists(modListPath);
                Files.createFile(modListPath, new FileAttribute[0]);
                Files.writeString(PFMRuntimeResources.createDirIfNeeded(modListPath), (CharSequence)PaladinFurnitureMod.getVersionMap().toString().replace("[", "").replace("]", ""), StandardOpenOption.APPEND);
            } else {
                this.log("Data Hash and Mod list matched, skipping generation");
            }
            PFMDataGenerator.setDataRunning(false);
        }
    }

    @Override
    public float getProgress() {
        return (float)this.count / 4.0f;
    }

    @Override
    public void setProgress(String progress) {
        this.progress = progress;
    }

    @Override
    public String getProgressString() {
        return this.progress;
    }
}

