/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.assets;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSinkBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.basicLamp.UnbakedBasicLampModel;
import com.unlikepaladin.pfm.client.model.PFMBedModelRenderer;
import com.unlikepaladin.pfm.client.model.PFMItemModel;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMTextureKeyFactory;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.TriFunc;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.blockstates.BlockStateGenerator;
import net.minecraft.client.data.models.blockstates.Condition;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.DelegatedModel;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PFMBlockstateModelProvider
extends PFMProvider {
    public static Map<Block, ResourceLocation> modelPathMap = new HashMap<Block, ResourceLocation>();
    private static final ResourceLocation replaceable = ResourceLocation.parse((String)"block/stone");

    public PFMBlockstateModelProvider(PFMGenerator parent) {
        super(parent);
        parent.setProgress("Generating Blockstates and Models");
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        Path path = this.getParent().getOutput();
        HashMap blockstates = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateSupplierConsumer = blockStateSupplier -> {
            Block block = blockStateSupplier.getBlock();
            BlockStateGenerator blockStateSupplier2 = blockstates.put(block, blockStateSupplier);
            if (blockStateSupplier2 != null) {
                this.getParent().getLogger().error("Duplicate blockstate definition for " + String.valueOf(block));
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet excludeBlockItem = Sets.newHashSet();
        BiConsumer<ResourceLocation, ModelInstance> identifierSupplierBiConsumer = (identifier, supplier) -> {
            Supplier supplier2 = (Supplier)models.put(identifier, supplier);
            if (supplier2 != null) {
                this.getParent().getLogger().error("Duplicate model definition for " + String.valueOf(identifier));
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(identifier));
            }
        };
        Consumer<Item> excludeBlockItemConsumer = excludeBlockItem::add;
        new PFMBlockStateModelGenerator(blockStateSupplierConsumer, identifierSupplierBiConsumer, excludeBlockItemConsumer).registerModelsAndStates();
        ArrayList<Item> generateModelFor = new ArrayList<Item>();
        modelPathMap.keySet().forEach(block -> {
            Item item = (Item)Item.BY_BLOCK.get(block);
            if (item != null) {
                if (excludeBlockItem.contains(item)) {
                    return;
                }
                ResourceLocation identifier = ModelLocationUtils.getModelLocation((Item)item);
                if (!models.containsKey(identifier)) {
                    models.put(identifier, new DelegatedModel(modelPathMap.get(block)));
                    generateModelFor.add(item);
                }
            }
        });
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, ItemModel.Unbaked> consumer = (id, unbakedModel) -> {
            ClientItem asset = new ClientItem(unbakedModel, ClientItem.Properties.DEFAULT);
            DataResult result = ClientItem.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)asset);
            if (result.isSuccess() && !itemModels.containsKey(id)) {
                itemModels.put(id, () -> ((DataResult)result).getOrThrow());
            } else if (result.isError()) {
                this.getParent().getLogger().error("Failed to load item model for: {} {}", id, result.error().get());
            }
        };
        new PFMItemModelGenerator(consumer, identifierSupplierBiConsumer).register(generateModelFor);
        this.writeJsons(path, blockstates, PFMBlockstateModelProvider::getBlockStateJsonPath);
        this.writeJsons(path, models, PFMBlockstateModelProvider::getModelJsonPath);
        this.writeJsons(path, itemModels, PFMBlockstateModelProvider::getItemsJsonPath);
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "PFM Models and BlockStates";
    }

    private static Path getBlockStateJsonPath(Path root, Block block) {
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        return root.resolve("assets/" + identifier.getNamespace() + "/blockstates/" + identifier.getPath() + ".json");
    }

    private static Path getModelJsonPath(Path root, ResourceLocation id) {
        return root.resolve("assets/" + id.getNamespace() + "/models/" + id.getPath() + ".json");
    }

    private static Path getItemsJsonPath(Path root, ResourceLocation id) {
        return root.resolve("assets/" + id.getNamespace() + "/items/" + id.getPath() + ".json");
    }

    private <T> void writeJsons(Path root, Map<T, ? extends Supplier<JsonElement>> jsons, BiFunction<Path, T, Path> locator) {
        jsons.forEach((object, supplier) -> {
            Path path2 = (Path)locator.apply(root, object);
            if (supplier != null && object != null && path2 != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    Files.createFile(path2, new FileAttribute[0]);
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("  ");
                    GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)((JsonElement)supplier.get()), (Comparator)KEY_COMPARATOR);
                    jsonWriter.flush();
                    Files.write(path2, byteArrayOutputStream.toByteArray(), StandardOpenOption.WRITE);
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    this.getParent().getLogger().error("Couldn't save {}", (Object)path2, (Object)exception);
                }
            }
        });
    }

    static class PFMBlockStateModelGenerator {
        public static Map<ModelTemplate, ResourceLocation> ModelIDS = new HashMap<ModelTemplate, ResourceLocation>();
        final Consumer<BlockStateGenerator> blockStateCollector;
        final BiConsumer<ResourceLocation, ModelInstance> modelCollector;
        final List<ResourceLocation> generatedStates = new ArrayList<ResourceLocation>();
        final Consumer<Item> simpleItemModelExemptionCollector;
        public static final TextureSlot LOG_KEY = PFMBlockStateModelGenerator.of("log");
        public static final TextureSlot LOG_TOP_KEY = PFMBlockStateModelGenerator.of("log_top");
        public static final ModelTemplate[] TEMPLATE_CHAIR = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair/template_chair", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("chair/template_chair", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_DINNER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_dinner/template_chair_dinner", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("chair_dinner/template_chair_dinner", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_CLASSIC = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_classic/template_chair_classic", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("chair_classic/template_chair_classic", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_MODERN = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_modern/template_chair_modern", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("chair_modern/template_chair_modern", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LOG_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("log_stool/log_stool", LOG_KEY, LOG_TOP_KEY), PFMBlockStateModelGenerator.block("log_stool/log_stool", "_tucked", LOG_KEY, LOG_TOP_KEY)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_stool/simple_stool", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("simple_stool/simple_stool", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_stool/classic_stool", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_stool/classic_stool", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_MODERN_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("modern_stool/modern_stool", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("modern_stool/modern_stool", "_tucked", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_BASIC_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_basic/table_basic", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_base", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_east", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_west", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_east", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_west", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east_top", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west_top", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_east_west_north", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_east_west_south", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east_bottom", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west_bottom", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_east_corner", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_west_corner", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_east_corner", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_west_corner", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_classic/table_classic", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_one_uved", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_one", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_two_uved", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_two", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LOG_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("log_table/log_table", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_middle", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_DINNER_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("dinner_table/dinner_table", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_MODERN_DINNER_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_NIGHTSTAND_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_middle_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_right_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_left_open", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_BED_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_bed/template/full/simple_bed_white", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head_right", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot_right", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/foot/simple_bed_foot_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/foot/simple_bed_foot_right", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/head/simple_bed_head", TextureSlot.TEXTURE)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_BED_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_bed/template/full/classic_bed_white", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head_right", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot_right", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/bunk/foot/classic_bed_foot_left", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("classic_bed/template/bunk/foot/classic_bed_foot_right", TextureSlot.TEXTURE)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_BUNK_LADDER_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_bunk_ladder/template/simple_ladder", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("simple_bunk_ladder/template/simple_ladder_top", TextureSlot.TEXTURE)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_COUNTER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_edge_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_edge_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_inner_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_inner_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_outer_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_outer_corner_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_DRAWER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_inner_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_inner_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_left_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_right_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_open_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_open_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_CABINET = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_open_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_open_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_open_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_open_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_DRAWER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_inner_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_inner_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_open_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_open_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_COUNTER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_inner_corner_left", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_inner_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_outer_corner_right", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_outer_corner_left", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_DRAWER_SMALL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_wall_drawer_small/kitchen_wall_drawer_small", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_wall_drawer_small/kitchen_wall_drawer_small", "_open", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_COUNTER_OVEN = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven_middle", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven", "_open", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven_middle", "_open", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_SINK = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_level1", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_level2", TextureSlot.TEXTURE, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_full", TextureSlot.TEXTURE, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LAMP_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_bottom", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_middle", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_single", TextureSlot.TEXTURE), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_top", TextureSlot.TEXTURE)};

        PFMBlockStateModelGenerator(Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<ResourceLocation, ModelInstance> modelCollector, Consumer<Item> simpleItemModelExemptionCollector) {
            this.blockStateCollector = blockStateCollector;
            this.modelCollector = modelCollector;
            this.simpleItemModelExemptionCollector = simpleItemModelExemptionCollector;
        }

        public void registerModelsAndStates() {
            this.registerTuckableChairs();
            this.registerTables();
            this.registerNightStands();
            this.registerBeds();
            this.registerLadders();
            this.registerCounters();
            this.registerLamp();
        }

        public void registerTuckableChairs() {
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMap(), "chair", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMapNonBase(), "chair", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMap(), "chair_dinner", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMapNonBase(), "chair_dinner", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMap(), "chair_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMapNonBase(), "chair_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMap(), "chair_classic", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMapNonBase(), "chair_classic", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariantToBlockMap(), "log_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMap(), "simple_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMapNonBase(), "simple_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMap(), "classic_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMapNonBase(), "classic_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMap(), "modern_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMapNonBase(), "modern_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
        }

        public void registerTables() {
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMap(), "table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMapNonBase(), "table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMap(), "table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMapNonBase(), "table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMap(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMapNonBase(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMap(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMapNonBase(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMap(), "dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMapNonBase(), "dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMap(), "modern_dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMapNonBase(), "modern_dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
        }

        public void registerNightStands() {
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMap(), "classic_nightstand", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMapNonBase(), "classic_nightstand", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
        }

        public void registerBeds() {
            this.generateModelAndBlockStateForBed(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList(), "simple_bed", PFMBlockStateModelGenerator::createBedBlockState);
            this.generateModelAndBlockStateForBed(PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariantToBlockMapList(), "simple_bed", PFMBlockStateModelGenerator::createBedBlockState);
        }

        public void registerLadders() {
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariantToBlockMap(), "simple_bunk_ladder", PFMBlockStateModelGenerator::createOrientableTableBlockState);
        }

        public void registerCounters() {
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMap(), "kitchen_counter", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMapNonBase(), "kitchen_counter", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMap(), "kitchen_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMapNonBase(), "kitchen_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMap(), "kitchen_cabinet", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMapNonBase(), "kitchen_cabinet", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMap(), "kitchen_wall_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMap(), "kitchen_wall_counter", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_counter", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMap(), "kitchen_wall_small_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_small_drawer", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMap(), "kitchen_counter_oven", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableKitchenCounter(block, identifiers, "", "", "", 180));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMapNonBase(), "kitchen_counter_oven", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableKitchenCounter(block, identifiers, "", "", "", 180));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMap(), "kitchen_sink", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMapNonBase(), "kitchen_sink", PFMBlockStateModelGenerator::createOrientableKitchenCounter);
        }

        public void registerLamp() {
            ResourceLocation modelID = ModelLocationUtils.getModelLocation((Block)PaladinFurnitureModBlocksItems.BASIC_LAMP);
            this.blockStateCollector.accept(PFMBlockStateModelGenerator.createSingleStateBlockState(PaladinFurnitureModBlocksItems.BASIC_LAMP, List.of(modelID)));
            modelPathMap.put(PaladinFurnitureModBlocksItems.BASIC_LAMP, UnbakedBasicLampModel.getItemModelId());
        }

        public static TextureMapping createPlankBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation legs = ModelHelper.getTextureId(variantBase.getBaseBlock());
            return new TextureMapping().put(TextureSlot.TEXTURE, top).put(LOG_KEY, legs);
        }

        public static TextureMapping createRawBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            return new TextureMapping().put(TextureSlot.TEXTURE, top).put(LOG_KEY, legs);
        }

        public static TextureMapping createPlankLogBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId(variantBase.getBaseBlock()) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            return new TextureMapping().put(TextureSlot.TEXTURE, top).put(LOG_KEY, legs);
        }

        public static TextureMapping createCounterBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation counterTop;
            ResourceLocation counterBase = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation resourceLocation = counterTop = stripped != false ? ModelHelper.getTextureId(variantBase.getBaseBlock()) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            if (variantBase.identifier.getPath().equals("granite")) {
                counterTop = ModelHelper.getTextureId(Blocks.POLISHED_GRANITE);
                counterBase = ModelHelper.getTextureId(Blocks.WHITE_TERRACOTTA);
            } else if (variantBase.identifier.getPath().equals("calcite") || variantBase.identifier.getPath().equals("netherite")) {
                ResourceLocation temp = counterBase;
                counterBase = counterTop;
                counterTop = temp;
            } else if (variantBase.identifier.getPath().equals("andesite")) {
                counterTop = ModelHelper.getTextureId(Blocks.POLISHED_ANDESITE);
                counterBase = ModelHelper.getTextureId(Blocks.STRIPPED_OAK_LOG);
            } else if (variantBase.identifier.getPath().equals("deepslate")) {
                counterTop = ModelHelper.getTextureId(Blocks.POLISHED_DEEPSLATE);
                counterBase = ModelHelper.getTextureId(Blocks.DARK_OAK_PLANKS);
            } else if (variantBase.identifier.getPath().equals("blackstone")) {
                counterTop = ModelHelper.getTextureId(Blocks.POLISHED_BLACKSTONE);
                counterBase = ModelHelper.getTextureId(Blocks.CRIMSON_PLANKS);
            }
            return new TextureMapping().put(TextureSlot.TEXTURE, counterBase).put(LOG_KEY, counterTop);
        }

        public static TextureMapping createLogLogTopBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log"), "_top") : ModelHelper.getTextureId(variantBase.getSecondaryBlock(), "_top");
            return new TextureMapping().put(LOG_KEY, legs).put(LOG_TOP_KEY, top);
        }

        public void generateBlockStateForBlock(Map<VariantBase<?>, ? extends Block> variantBaseHashMap, String blockName, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction) {
            variantBaseHashMap.forEach((variantBase, block) -> {
                if (!this.generatedStates.contains(BuiltInRegistries.BLOCK.getKey(block))) {
                    ResourceLocation modelID = ModelLocationUtils.getModelLocation((Block)block);
                    ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modelID.getNamespace(), (String)("block/" + blockName));
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(1);
                    ids.add(id);
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply((Block)block, (List<ResourceLocation>)ids));
                    this.generatedStates.add(BuiltInRegistries.BLOCK.getKey(block));
                    modelPathMap.put((Block)block, replaceable);
                }
            });
        }

        public void generateModelAndBlockStateForBed(HashMap<VariantBase<?>, ? extends Set<?>> variantBaseHashMap, String blockName, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction) {
            variantBaseHashMap.forEach((variantBase, blockList) -> blockList.forEach(block1 -> {
                Block block = (Block)block1;
                if (!this.generatedStates.contains(BuiltInRegistries.BLOCK.getKey((Object)block))) {
                    ResourceLocation modelID = ModelLocationUtils.getModelLocation((Block)block);
                    ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modelID.getNamespace(), (String)("block/" + blockName));
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(1);
                    ids.add(id);
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply(block, ids));
                    this.generatedStates.add(BuiltInRegistries.BLOCK.getKey((Object)block));
                    modelPathMap.put(block, replaceable);
                }
            }));
        }

        public void generateModelAndBlockStateForVariants(Map<VariantBase<?>, ? extends Block> variantBaseHashMap, String blockName, ModelTemplate[] models, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction, BiFunction<Boolean, VariantBase<?>, TextureMapping> textureBiFunction) {
            variantBaseHashMap.forEach((variantBase, block) -> {
                if (!this.generatedStates.contains(BuiltInRegistries.BLOCK.getKey(block))) {
                    String strippedprefix;
                    String blockName2 = blockName;
                    boolean stripped = block.getDescriptionId().contains("stripped");
                    TextureMapping blockTexture = (TextureMapping)textureBiFunction.apply(stripped, (VariantBase<?>)variantBase);
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                    String string = strippedprefix = stripped ? "stripped_" : "";
                    if (block instanceof RawLogTableBlock) {
                        blockName2 = "raw_log_table";
                    }
                    if (variantBase instanceof StoneVariant && block instanceof LogTableBlock) {
                        blockName2 = blockName2.replace("log", "natural");
                    } else if (variantBase.isNetherWood() && block instanceof LogTableBlock) {
                        blockName2 = blockName2.replace("log", "stem");
                    }
                    ResourceLocation modelID = ModelLocationUtils.getModelLocation((Block)block);
                    for (ModelTemplate model : models) {
                        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modelID.getNamespace(), (String)ModelIDS.get(model).getPath().replace("template_", "").replace("template", "").replaceAll(blockName, strippedprefix + variantBase.getSerializedName() + "_" + blockName2).replace("block/", "block/" + blockName + "/").replace("//", "/"));
                        model.create(id, blockTexture, this.modelCollector);
                        ids.add(id);
                    }
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply((Block)block, (List<ResourceLocation>)ids));
                    modelPathMap.put((Block)block, (ResourceLocation)ids.get(0));
                    this.generatedStates.add(BuiltInRegistries.BLOCK.getKey(block));
                }
            });
        }

        public void generateModelAndBlockStateForBed(HashMap<VariantBase<?>, ? extends List<?>> variantBaseHashMap, String blockName, ModelTemplate[] models, TriFunc<Block, List<ResourceLocation>, String, BlockStateGenerator> stateSupplierBiFunction, BiFunction<Boolean, VariantBase<?>, TextureMapping> textureBiFunction) {
            variantBaseHashMap.forEach((variantBase, blockList) -> {
                ArrayList allids = new ArrayList();
                blockList.forEach(block1 -> {
                    Block block = (Block)block1;
                    if (!this.generatedStates.contains(BuiltInRegistries.BLOCK.getKey((Object)block))) {
                        boolean stripped = block.getDescriptionId().contains("stripped");
                        TextureMapping blockTexture = (TextureMapping)textureBiFunction.apply(stripped, (VariantBase<?>)variantBase);
                        ResourceLocation modelID = ModelLocationUtils.getModelLocation((Block)block);
                        String color = block instanceof SimpleBedBlock ? ((SimpleBedBlock)block).getPFMColor().getSerializedName() : "";
                        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                        for (ModelTemplate model : models) {
                            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modelID.getNamespace(), (String)ModelIDS.get(model).getPath().replaceAll("white", color).replaceAll("template", variantBase.getSerializedName()));
                            if (allids.contains(id)) continue;
                            if (model == models[0]) {
                                PFMBlockStateModelGenerator.block(blockName + "/template/full/" + blockName + "_" + color, TextureSlot.TEXTURE).create(id, blockTexture, this.modelCollector);
                            } else {
                                model.create(block, blockTexture, this.modelCollector);
                            }
                            ids.add(id);
                        }
                        allids.addAll(ids);
                        this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply(block, ids, color));
                        modelPathMap.put(block, (ResourceLocation)ids.get(0));
                        this.generatedStates.add(BuiltInRegistries.BLOCK.getKey((Object)block));
                    }
                });
            });
        }

        private static ModelTemplate make(TextureSlot ... requiredTextures) {
            return new ModelTemplate(Optional.empty(), Optional.empty(), requiredTextures);
        }

        private static ModelTemplate block(String parent, TextureSlot ... requiredTextures) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)("block/" + parent));
            ModelTemplate model = new ModelTemplate(Optional.of(id), Optional.empty(), requiredTextures);
            ModelIDS.put(model, id);
            return model;
        }

        private static ModelTemplate item(String parent, TextureSlot ... requiredTextures) {
            return new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)("item/" + parent))), Optional.empty(), requiredTextures);
        }

        private static ModelTemplate block(String parent, String variant, TextureSlot ... requiredTextures) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)("block/" + parent + variant));
            ModelTemplate model = new ModelTemplate(Optional.of(id), Optional.of(variant), requiredTextures);
            ModelIDS.put(model, id);
            return model;
        }

        private static TextureSlot of(String name) {
            return PFMTextureKeyFactory.newTextureKey(name, null);
        }

        private static TextureSlot of(String name, TextureSlot parent) {
            return PFMTextureKeyFactory.newTextureKey(name, parent);
        }

        private static BlockStateGenerator createSingleStateBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            String path = modelIdentifiers.get(0).getPath();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modelIdentifiers.get(0).getNamespace(), (String)(path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47))));
            Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)id);
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)variant);
        }

        private static BlockStateGenerator createAxisOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            HashMap<Direction.Axis, Variant> variantMap = new HashMap<Direction.Axis, Variant>();
            String path = modelIdentifiers.get(0).getPath();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : ResourceLocation.fromNamespaceAndPath((String)modelIdentifiers.get(0).getNamespace(), (String)(path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47))));
            Integer[] rotationArray = new Integer[]{0, 90};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 90) {
                    if (rotationArray[i] == 90) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.Axis.Z, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.Axis.X, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_AXIS).generate(axis -> {
                for (Direction.Axis axis1 : variantMap.keySet()) {
                    if (!axis.equals((Object)axis1)) continue;
                    return (Variant)variantMap.get(axis1);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createAxisOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableTableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            String path = modelIdentifiers.get(0).getPath();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : ResourceLocation.fromNamespaceAndPath((String)modelIdentifiers.get(0).getNamespace(), (String)(path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47))));
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 270) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            variantMap.put(Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
            variantMap.put(Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).generate(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createOrientableKitchenCounter(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableKitchenCounter(block, modelIdentifiers, "", "", "", 0);
        }

        private static BlockStateGenerator createOrientableKitchenCounter(Block block, List<ResourceLocation> modelIdentifiers, String override, String furnitureName, String replacement, int rotation) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            String path = modelIdentifiers.get(0).getPath().replaceAll(override, "");
            String name = path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47));
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : ResourceLocation.fromNamespaceAndPath((String)modelIdentifiers.get(0).getNamespace(), (String)name.replace(furnitureName, replacement));
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 180) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))).with(VariantProperties.UV_LOCK, (Object)true));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).generate(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createKitchenSink(Block block, List<ResourceLocation> modelIdentifiers) {
            HashMap<Direction, VariantProperties.Rotation> rotationMap = new HashMap<Direction, VariantProperties.Rotation>();
            Integer[] rotation = new Integer[]{0, 90, 180, 270};
            rotationMap.put(Direction.NORTH, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0]))));
            rotationMap.put(Direction.EAST, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1]))));
            rotationMap.put(Direction.SOUTH, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2]))));
            rotationMap.put(Direction.WEST, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3]))));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)AbstractSinkBlock.LEVEL_4).generate((facing, level) -> Variant.variant().with(VariantProperties.MODEL, (Object)((ResourceLocation)modelIdentifiers.get((int)level))).with(VariantProperties.Y_ROT, (Object)((VariantProperties.Rotation)rotationMap.get(facing))).with(VariantProperties.UV_LOCK, (Object)true)));
        }

        private static BlockStateGenerator createSmallKitchenDrawer(Block block, List<ResourceLocation> modelIdentifiers, String override, String furnitureName, String replacement) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            HashMap<Direction, Variant> variantMapOpen = new HashMap<Direction, Variant>();
            Integer[] rotation = new Integer[]{0, 90, 180, 270};
            variantMap.put(Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMap.put(Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMapOpen.put(Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMapOpen.put(Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMapOpen.put(Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2])))).with(VariantProperties.UV_LOCK, (Object)true));
            variantMapOpen.put(Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3])))).with(VariantProperties.UV_LOCK, (Object)true));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.OPEN).generate((facing, open) -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return open != false ? (Variant)variantMapOpen.get(direction) : (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createLadderBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            Condition.TerminalCondition northFalse = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition northTrue = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition eastFalse = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition eastTrue = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition westFalse = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition westTrue = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition southFalse = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition southTrue = Condition.condition().term((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            return MultiPartGenerator.multiPart((Block)block).with((Condition)northFalse, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0))).with((Condition)northTrue, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1))).with((Condition)eastFalse, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)eastTrue, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)westFalse, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).with((Condition)westTrue, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).with((Condition)southFalse, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(0)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).with((Condition)southTrue, Variant.variant().with(VariantProperties.MODEL, (Object)modelIdentifiers.get(1)).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
        }

        private static BlockStateGenerator createBedBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : ModelLocationUtils.getModelLocation((Block)block);
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            variantMap.put(Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            variantMap.put(Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
            variantMap.put(Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).generate(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createOrientableTuckableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableTuckableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTuckableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            int i;
            HashMap<TuckableVariant, Variant> variantList = new HashMap<TuckableVariant, Variant>();
            Integer[] rotationArray = new Integer[]{90, 270, 180, 0};
            for (i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 270) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            for (i = 0; i <= 1; ++i) {
                boolean tucked = i == 1;
                ResourceLocation id = tucked ? modelIdentifiers.get(1) : modelIdentifiers.get(0);
                block8: for (Direction direction2 : Direction.values()) {
                    if (direction2.getAxis().isVertical()) continue;
                    switch (direction2) {
                        case NORTH: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
                            continue block8;
                        }
                        case SOUTH: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
                            continue block8;
                        }
                        case EAST: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
                            continue block8;
                        }
                        case WEST: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
                        }
                    }
                }
            }
            return MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BasicChairBlock.TUCKED).generate((direction, aBoolean) -> {
                for (TuckableVariant tuckableVariant : variantList.keySet()) {
                    if (!tuckableVariant.direction.equals(direction) || tuckableVariant.tucked != aBoolean) continue;
                    return (Variant)variantList.get(tuckableVariant);
                }
                return null;
            }));
        }

        private static class TuckableVariant {
            final boolean tucked;
            final Direction direction;
            static List<TuckableVariant> variants = new ArrayList<TuckableVariant>();

            private TuckableVariant(boolean tucked, Direction direction) {
                this.tucked = tucked;
                this.direction = direction;
                variants.add(this);
            }

            public static TuckableVariant get(Direction direction, Boolean tucked) {
                for (TuckableVariant tuckableVariant : variants) {
                    if (tuckableVariant.tucked != tucked || !direction.equals((Object)tuckableVariant.direction)) continue;
                    return tuckableVariant;
                }
                return null;
            }
        }
    }

    static class PFMItemModelGenerator {
        final BiConsumer<ResourceLocation, ItemModel.Unbaked> output;
        public final BiConsumer<ResourceLocation, ModelInstance> modelCollector;

        PFMItemModelGenerator(BiConsumer<ResourceLocation, ItemModel.Unbaked> output, BiConsumer<ResourceLocation, ModelInstance> modelCollector) {
            this.output = output;
            this.modelCollector = modelCollector;
        }

        public final void registerBasicModel(Item item) {
            this.output.accept(BuiltInRegistries.ITEM.getKey((Object)item), ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)item)));
        }

        public final void registerFurnitureModel(Item item) {
            this.output.accept(BuiltInRegistries.ITEM.getKey((Object)item), new PFMItemModel.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Optional.empty(), List.of()));
        }

        public final void registerFurnitureModel(Item item, SpecialModelRenderer.Unbaked specialModel) {
            this.output.accept(BuiltInRegistries.ITEM.getKey((Object)item), new PFMItemModel.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Optional.of(specialModel), List.of()));
        }

        public final void registerFurnitureModel(Item item, SpecialModelRenderer.Unbaked specialModel, List<ItemTintSource> tints) {
            this.output.accept(BuiltInRegistries.ITEM.getKey((Object)item), new PFMItemModel.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Optional.of(specialModel), tints));
        }

        public void register(List<Item> items) {
            for (Block block : PaladinFurnitureModBlocksItems.getBeds()) {
                if (!(block instanceof DyeableFurnitureBlock)) continue;
                this.registerFurnitureModel(block.asItem(), new PFMBedModelRenderer.Unbaked(((DyeableFurnitureBlock)block).getPFMColor()));
            }
            for (Item item : items) {
                this.registerFurnitureModel(item);
            }
        }
    }
}

