/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FurnitureRecipeJsonFactory
implements RecipeBuilder {
    private final ItemStack stack;
    private final NonNullList<Ingredient> inputs = NonNullList.create();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private boolean showNotification = true;
    @Nullable
    private String group;

    public FurnitureRecipeJsonFactory(ItemLike output, int outputCount) {
        this.stack = output.asItem().getDefaultInstance().copyWithCount(outputCount);
    }

    public FurnitureRecipeJsonFactory(ItemStack stack) {
        this.stack = stack;
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output, int count) {
        return new FurnitureRecipeJsonFactory(output, count);
    }

    public static FurnitureRecipeJsonFactory create(ItemStack stack) {
        return new FurnitureRecipeJsonFactory(stack);
    }

    public static FurnitureRecipeJsonFactory create(ItemLike output) {
        return new FurnitureRecipeJsonFactory(output, 1);
    }

    public FurnitureRecipeJsonFactory input(HolderSet<Item> tag) {
        return this.input(Ingredient.of(tag));
    }

    public FurnitureRecipeJsonFactory input(ItemLike itemProvider) {
        return this.input(itemProvider, 1);
    }

    public FurnitureRecipeJsonFactory input(ItemLike itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.input(Ingredient.of((ItemLike[])new ItemLike[]{itemProvider}));
        }
        return this;
    }

    public FurnitureRecipeJsonFactory input(Ingredient ingredient) {
        return this.input(ingredient, 1);
    }

    public FurnitureRecipeJsonFactory input(Ingredient ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputs.add((Object)ingredient);
        }
        return this;
    }

    public FurnitureRecipeJsonFactory criterion(String name, Criterion<?> criterionConditions) {
        this.criteria.put(name, criterionConditions);
        return this;
    }

    public FurnitureRecipeJsonFactory group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public FurnitureRecipeJsonFactory showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public Item getResult() {
        return this.stack.getItem();
    }

    public void save(RecipeOutput exporter, ResourceKey<Recipe<?>> recipeKey) {
        Advancement.Builder advancement$builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(recipeKey)).rewards(AdvancementRewards.Builder.recipe(recipeKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        exporter.accept(recipeKey, (Recipe)new FurnitureRecipe(this.group == null || this.group.isBlank() ? "" : this.group, this.stack, this.inputs), advancement$builder.build(recipeKey.location().withPrefix("recipes/furniture/")));
    }

    public void offerTo(RecipeOutput exporter, ResourceLocation recipeId) {
        FurnitureRecipe recipe = new FurnitureRecipe(this.group == null || this.group.isBlank() ? "" : this.group, this.stack, this.inputs);
        ResourceKey recipeKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
        Advancement.Builder advancement$builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)recipeKey)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)recipeKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        exporter.accept(recipeKey, (Recipe)recipe, advancement$builder.build(recipeKey.location().withPrefix("recipes/furniture/")));
    }

    private void validate(ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }
}

