/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ArmChairBlock;
import com.unlikepaladin.pfm.blocks.ArmChairColoredBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairDyeableBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.CutleryBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.FroggyChairBlock;
import com.unlikepaladin.pfm.blocks.HerringbonePlankBlock;
import com.unlikepaladin.pfm.blocks.IronStoveBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenRangeHoodBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenStovetopBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.MicrowaveBlock;
import com.unlikepaladin.pfm.blocks.MirrorBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PlateBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.ShowerTowelBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleSofaBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.data.FurnitureRecipeJsonFactory;
import com.unlikepaladin.pfm.runtime.data.neoforge.PFMRecipeProviderImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class PFMRecipeProvider
extends PFMProvider {
    public PFMRecipeProvider(PFMGenerator parent) {
        super(parent);
        parent.setProgress("Generating Recipes");
    }

    private static HolderLookup.Provider createWrapperLookup() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        return builder.build((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        final Path path = this.getParent().getOutput();
        final HashSet set = Sets.newHashSet();
        final HolderLookup.Provider lookup = PFMRecipeProvider.createWrapperLookup();
        this.generateRecipes(new RecipeOutput(){

            public void accept(ResourceKey<Recipe<?>> recipeId, Recipe<?> recipe, @Nullable AdvancementHolder advancementEntry) {
                if (!set.add(recipeId)) {
                    PFMRecipeProvider.this.getParent().getLogger().error("Duplicate recipe " + String.valueOf(recipeId));
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipeId));
                }
                if (recipe == null) {
                    PFMRecipeProvider.this.getParent().getLogger().error("Recipe Json Provider is null");
                    throw new IllegalStateException("Recipe Json Provider is null");
                }
                RegistryOps ops = lookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                PFMRecipeProvider.this.saveRecipe((JsonElement)Recipe.CODEC.encodeStart((DynamicOps)ops, recipe).getOrThrow(IllegalStateException::new), path.resolve("data/" + recipeId.location().getNamespace() + "/recipe/" + recipeId.location().getPath() + ".json"));
                if (advancementEntry != null) {
                    PFMRecipeProvider.this.saveRecipeAdvancement((JsonElement)Advancement.CODEC.encodeStart((DynamicOps)ops, (Object)advancementEntry.value()).getOrThrow(IllegalStateException::new), path.resolve("data/" + recipeId.location().getNamespace() + "/advancement/" + advancementEntry.id().getPath() + ".json"));
                }
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }

            public void includeRootAdvancement() {
            }
        });
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "PFM Recipes";
    }

    private void saveRecipe(JsonElement json, Path path) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            jsonWriter.setSerializeNulls(false);
            jsonWriter.setIndent("  ");
            GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)json, (Comparator)KEY_COMPARATOR);
            jsonWriter.flush();
            Files.write(path, byteArrayOutputStream.toByteArray(), StandardOpenOption.WRITE);
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            this.getParent().getLogger().error("Couldn't save {}", (Object)path, (Object)exception);
        }
    }

    private void saveRecipeAdvancement(JsonElement json, Path path) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            jsonWriter.setSerializeNulls(false);
            jsonWriter.setIndent("  ");
            GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)json, (Comparator)KEY_COMPARATOR);
            jsonWriter.flush();
            Files.write(path, byteArrayOutputStream.toByteArray(), StandardOpenOption.WRITE);
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            this.getParent().getLogger().error("Couldn't save {}", (Object)path, (Object)exception);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static ResourceLocation getId(Block block) {
        return PFMRecipeProviderImpl.getId(block);
    }

    protected void generateRecipes(RecipeOutput exporter) {
        FurnitureBlock[] mirrors;
        FurnitureBlock[] showerTowels;
        FurnitureBlock[] basicToilets;
        FurnitureBlock[] cutleries;
        FurnitureBlock[] plates;
        KitchenStovetopBlock[] stovetopBlocks;
        FurnitureBlock[] ironStove;
        FurnitureBlock[] stoves;
        FurnitureBlock[] rangeHoods;
        FurnitureBlock[] microwaves;
        FurnitureBlock[] freezers;
        FurnitureBlock[] fridges;
        FurnitureBlock[] herringbonePlanks;
        FurnitureBlock[] leatherArmChairs;
        FurnitureBlock[] simpleSofas;
        FurnitureBlock[] armChairs;
        FurnitureBlock[] woolClassicChairs;
        FurnitureBlock[] froggyChairs;
        ArrayList<ResourceLocation> generatedRecipes = new ArrayList<ResourceLocation>();
        PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerDinnerChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerDinnerChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        for (FurnitureBlock froggyChair : froggyChairs = FroggyChairBlock.streamFroggyChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(froggyChair.getBlock()))) continue;
            PFMRecipeProvider.offerFroggyChairRecipe((ItemLike)froggyChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{froggyChair.getFroggyChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(froggyChair.getBlock()));
        }
        for (FurnitureBlock classicChair : woolClassicChairs = ClassicChairDyeableBlock.streamWoodDyeableChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(classicChair.getBlock()))) continue;
            PFMRecipeProvider.offerClassicChairRecipe((ItemLike)classicChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{classicChair.getArmChairMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(classicChair.getBlock()));
        }
        PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernChairRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        for (FurnitureBlock armChair : armChairs = ArmChairColoredBlock.streamArmChairColored().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        for (FurnitureBlock sofa : simpleSofas = SimpleSofaBlock.streamSimpleSofas().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(sofa.getBlock()))) continue;
            PFMRecipeProvider.offerSimpleSofaRecipe((ItemLike)sofa.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{sofa.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(sofa.getBlock()));
        }
        for (FurnitureBlock armChair : leatherArmChairs = ArmChairBlock.streamArmChairs().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                if (block.toString().contains("raw")) {
                    PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), exporter);
                } else {
                    PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                }
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                if (block.toString().contains("raw") && block.toString().contains("stripped")) {
                    PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                } else {
                    PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                }
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerLogTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerDinnerTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerDinnerTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernDinnerTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernDinnerTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicNightStandRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicNightStandRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList().forEach((variantBase, blockList) -> blockList.forEach(block -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerSimpleBedRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{this.getVanillaBed((Block)block)}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        }));
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariantToBlockMapList().forEach((variantBase, blockList) -> blockList.forEach(block -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicBedRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{this.getVanillaBed((Block)block)}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("fence")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        }));
        PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerSimpleBunkLadderRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerLogStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerSimpleStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerSimpleStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernStoolRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerCounterRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerCounterRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerKitchenSinkRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerKitchenSinkRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerCounterApplianceRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerCounterApplianceRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerCounterApplianceRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerCounterApplianceRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerCounterRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerCounterRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerWallDrawerRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerWallDrawerRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerWallDrawerSmallRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerWallDrawerSmallRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Tuple<Block, Block> materials = PFMRecipeProvider.getCounterMaterials(variantBase);
                PFMRecipeProvider.offerCabinetRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getB()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)materials.getA()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerCabinetRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        for (FurnitureBlock herringbonePlank : herringbonePlanks = HerringbonePlankBlock.streamPlanks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(herringbonePlank.getBlock()))) continue;
            PFMRecipeProvider.offerHerringbonePlanks((ItemLike)herringbonePlank.getBlock(), herringbonePlank.getSlab().asItem(), exporter);
        }
        for (FurnitureBlock fridge : fridges = FridgeBlock.streamFridges().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(fridge.getBlock()))) continue;
            PFMRecipeProvider.offerFridgeRecipe((ItemLike)fridge.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{fridge.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(fridge.getBlock()));
        }
        for (FurnitureBlock freezer : freezers = FreezerBlock.streamFreezers().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(freezer.getBlock()))) continue;
            PFMRecipeProvider.offerFreezerRecipe((ItemLike)freezer.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{freezer.getFridgeMaterial().asItem()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(freezer.getBlock()));
        }
        for (FurnitureBlock microwave : microwaves = MicrowaveBlock.streamMicrowaves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(microwave.getBlock()))) continue;
            PFMRecipeProvider.offerMicrowaveRecipe((ItemLike)microwave.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{microwave.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(microwave.getBlock()));
        }
        for (FurnitureBlock rangeHood : rangeHoods = KitchenRangeHoodBlock.streamOvenRangeHoods().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(rangeHood.getBlock()))) continue;
            PFMRecipeProvider.offerRangeHoodRecipe((ItemLike)rangeHood.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{rangeHood.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_LAMP}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(rangeHood.getBlock()));
        }
        for (FurnitureBlock stove : stoves = StoveBlock.streamStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (FurnitureBlock stove : ironStove = IronStoveBlock.streamIronStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (KitchenStovetopBlock stove : stovetopBlocks = KitchenStovetopBlock.streamKitchenStovetop().toList().toArray(new KitchenStovetopBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId((Block)stove))) continue;
            PFMRecipeProvider.offerStovetopRecipe((ItemLike)stove, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRAY_CONCRETE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)stove));
        }
        for (FurnitureBlock plate : plates = PlateBlock.streamPlates().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(plate.getBlock()))) continue;
            PFMRecipeProvider.offerPlateRecipe((ItemLike)plate.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{plate.getPlateMaterial()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ITEM_FRAME}), Ingredient.of((ItemLike[])new ItemLike[]{plate.getPlateDecoration()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(plate.getBlock()));
        }
        for (FurnitureBlock cutlery : cutleries = CutleryBlock.streamCutlery().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(cutlery.getBlock()))) continue;
            PFMRecipeProvider.offerCutleryRecipe((ItemLike)cutlery.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{cutlery.getCutleryMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(cutlery.getBlock()));
        }
        PaladinFurnitureMod.furnitureEntryMap.get(PendantBlock.class).getAllBlocks().forEach(block -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Block hang = Blocks.LIGHT_GRAY_CONCRETE;
                Block base = block == PaladinFurnitureModBlocksItems.GLASS_MODERN_PENDANT ? Blocks.WHITE_STAINED_GLASS : (block == PaladinFurnitureModBlocksItems.WHITE_MODERN_PENDANT ? Blocks.WHITE_CONCRETE : Blocks.GRAY_CONCRETE);
                PFMRecipeProvider.offerPendantRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{base}), Ingredient.of((ItemLike[])new ItemLike[]{hang}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        if (!generatedRecipes.contains(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM))) {
            FurnitureRecipeJsonFactory.create(PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM.getDefaultInstance().copyWithCount(6)).input((ItemLike)Blocks.WHITE_CONCRETE, 6).input((ItemLike)Blocks.LIGHT_GRAY_CONCRETE, 2).input((ItemLike)Items.REDSTONE).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM.getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM));
        }
        for (FurnitureBlock toilet : basicToilets = BasicToiletBlock.streamBasicToilet().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(toilet.getBlock()))) continue;
            PFMRecipeProvider.offerToiletRecipe((ItemLike)toilet.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_BUTTON}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(toilet.getBlock()));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER))) {
            PFMRecipeProvider.offerWallToiletPaperRecipe((ItemLike)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK))) {
            PFMRecipeProvider.offerSinkRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SINK, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB))) {
            PFMRecipeProvider.offerBathtubRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_BATHTUB, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.QUARTZ_BLOCK}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD))) {
            PFMRecipeProvider.offerShowerHeadRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD, Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), exporter);
            PFMRecipeProvider.offerShowerHandleRecipe(PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM.getDefaultInstance(), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.LEVER}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD));
            generatedRecipes.add(BuiltInRegistries.ITEM.getKey((Object)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN))) {
            FurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.MESH_TRASHCAN, 1).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.ENDER_PEARL, 1).input((ItemLike)Blocks.IRON_BARS, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.MESH_TRASHCAN.asItem().getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN))) {
            FurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.TRASHCAN, 1).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.ENDER_PEARL, 1).input((ItemLike)Blocks.IRON_BARS, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)PaladinFurnitureModBlocksItems.TRASHCAN.asItem().getDescriptionId().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN));
        }
        for (FurnitureBlock towel : showerTowels = ShowerTowelBlock.streamShowerTowels().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(towel.getBlock()))) continue;
            PFMRecipeProvider.offerShowerTowelRecipe((ItemLike)towel.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{towel.getWoolColor()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(towel.getBlock()));
        }
        for (FurnitureBlock mirror : mirrors = MirrorBlock.streamMirrorBlocks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(mirror.getBlock()))) continue;
            PFMRecipeProvider.offerMirrorRecipe((ItemLike)mirror.getBlock(), Ingredient.of((ItemLike[])new ItemLike[]{mirror.getBaseMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(mirror.getBlock()));
        }
        PFMRecipeProvider.offerLampRecipes(exporter);
        PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerBasicCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerModernCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMap().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getSecondaryBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                PFMRecipeProvider.offerClassicCoffeeTableRecipe((ItemLike)block.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{variantBase.getBaseBlock()}), Ingredient.of((ItemLike[])new ItemLike[]{(Block)variantBase.getChild("stripped_log")}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> pfmModCompatibility.generateRecipes(exporter));
    }

    public static void offerLampRecipes(RecipeOutput exporter) {
        for (WoodVariant variant : WoodVariantRegistry.getVariants()) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack stack = new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_LAMP);
                stack.set(PFMComponents.VARIANT_COMPONENT, (Object)variant.identifier);
                stack.set(PFMComponents.COLOR_COMPONENT, (Object)color);
                FurnitureRecipeJsonFactory.create(stack).input((ItemLike)ModelHelper.getWoolColor(color.getSerializedName()), 3).input((ItemLike)((Block)variant.getChild("stripped_log")), 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)String.format("basic_%s_%s_lamp", color.getSerializedName(), variant.getSerializedName())));
            }
        }
    }

    public static Tuple<Block, Block> getCounterMaterials(VariantBase<?> variantBase) {
        Block counterTop = variantBase.getSecondaryBlock();
        Block counterBase = variantBase.getBaseBlock();
        if (variantBase.identifier.getPath().equals("calcite") || variantBase.identifier.getPath().equals("netherite")) {
            Block temp = counterBase;
            counterBase = counterTop;
            counterTop = temp;
        }
        return new Tuple((Object)counterBase, (Object)counterTop);
    }

    public Block getVanillaBed(Block block) {
        if (block instanceof SimpleBedBlock) {
            String color = ((SimpleBedBlock)block).getPFMColor().getName();
            return (Block)BuiltInRegistries.BLOCK.getValue(ResourceLocation.parse((String)("minecraft:" + color + "_bed")));
        }
        return null;
    }

    public static void offerBasicChairRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerFroggyChairRecipe(ItemLike output, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion("has_concrete", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 6).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerDinnerChairRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicChairRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerModernChairRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerArmChairRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSimpleSofaRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerBasicTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 5).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerBasicCoffeeTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerModernCoffeeTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicCoffeeTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerLogTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output, "has_log"), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerHerringbonePlanks(ItemLike output, Item baseMaterial, RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((HolderGetter)PFMRecipeProvider.createWrapperLookup().lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).define(Character.valueOf('X'), (ItemLike)baseMaterial).pattern("XX").pattern("XX").unlockedBy("has_wood_slabs", PFMRecipeProvider.conditionsFromItem((ItemLike)baseMaterial)).save(exporter, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", ""))));
    }

    public static void offerDinnerTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerModernDinnerTableRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("tables").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 5).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicNightStandRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("bedroom").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 6).input(baseMaterial, 1).input((ItemLike)Blocks.CHEST, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static String getCriterionNameFromOutput(ItemLike output) {
        return PFMRecipeProvider.getCriterionNameFromOutput(output, "");
    }

    public static String getCriterionNameFromOutput(ItemLike output, String type) {
        if (Block.byItem((Item)output.asItem()) == null || Block.byItem((Item)output.asItem()) == Blocks.AIR || !PaladinFurnitureMod.furnitureEntryMap.containsKey(Block.byItem((Item)output.asItem()).getClass())) {
            return PFMRecipeProvider.getItemPath(output);
        }
        if (PaladinFurnitureMod.furnitureEntryMap.get(Block.byItem((Item)output.asItem()).getClass()).getVariantFromEntry(Block.byItem((Item)output.asItem())) instanceof WoodVariant) {
            return type.isEmpty() ? "has_planks" : type;
        }
        return PFMRecipeProvider.getItemPath(output);
    }

    public static void offerSimpleBedRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseBed, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bedroom").criterion("has_bed", PFMRecipeProvider.conditionsFromIngredient(baseBed)).input(legMaterial, 5).input(baseBed, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicBedRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseBed, Ingredient fence, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bedroom").criterion("has_bed", PFMRecipeProvider.conditionsFromIngredient(baseBed)).input(legMaterial, 3).input(baseBed, 1).input(fence, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSimpleBunkLadderRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("bedroom").input(base, 1).criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(base)).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), 6).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerLogStoolRecipe(ItemLike output, Ingredient legMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("stools").criterion("has_log", PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSimpleStoolRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("stools").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerClassicStoolRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("stools").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerModernStoolRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("stools").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 1).input(baseMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerCounterRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 6).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 6).input(legMaterial, 3).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerCounterApplianceRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, Ingredient appliance, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 5).input(legMaterial, 3).input(appliance).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerKitchenSinkRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, Ingredient center, Ingredient ingot, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 5).input(legMaterial, 2).input(ingot).input(center).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerWallDrawerRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, Ingredient appliace, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 6).input(baseMaterial, 2).input(appliace).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerWallDrawerSmallRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, Ingredient appliance, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 3).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 3).input(baseMaterial, 2).input(appliance).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerCabinetRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, Ingredient chest, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_planks", PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 6).input(baseMaterial, 2).input(chest).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerFridgeRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        if (output.asItem().toString().contains("xbox")) {
            FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 6).input(storage, 1).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_CONCRETE})).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
        } else {
            FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(storage).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
        }
    }

    public static void offerFreezerRecipe(ItemLike output, Ingredient legMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerMicrowaveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 5).input(storage).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerRangeHoodRecipe(ItemLike output, Ingredient legMaterial, Ingredient secondMaterial, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 4).input(secondMaterial).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerStoveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 8).input(storage).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerStovetopRecipe(ItemLike output, Ingredient base, Ingredient material, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 6).input(material, 2).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL})).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerPlateRecipe(ItemLike output, Ingredient base, Ingredient frame, Ingredient decoration, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(frame).input(decoration, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerCutleryRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerPendantRecipe(ItemLike output, Ingredient base, Ingredient hang, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 4).group("lighting").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input(hang, 2).input((ItemLike)PaladinFurnitureModBlocksItems.SIMPLE_LIGHT).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerToiletRecipe(ItemLike output, Ingredient base, Ingredient material, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(material), PFMRecipeProvider.conditionsFromIngredient(material)).input(base).input(material, 4).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET})).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerWallToiletPaperRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath((ItemLike)Items.PAPER), PFMRecipeProvider.conditionsFromItem((ItemLike)Items.PAPER)).input(base, 1).input((ItemLike)Items.PAPER, 8).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerSinkRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input((ItemLike)Items.STONE_BUTTON, 2).input((ItemLike)Items.IRON_INGOT, 1).input((ItemLike)Items.BUCKET, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerBathtubRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 5).input((ItemLike)Items.STONE_BUTTON, 2).input((ItemLike)Items.BUCKET, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerHeadRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 1).input((ItemLike)Items.REDSTONE, 1).input((ItemLike)Items.IRON_INGOT, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerHandleRecipe(ItemStack output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input((ItemLike)Items.REDSTONE, 1).input((ItemLike)Items.IRON_INGOT, 1).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.getItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerShowerTowelRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_GRAY_CONCRETE}), 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    public static void offerMirrorRecipe(ItemLike output, Ingredient base, RecipeOutput exporter) {
        FurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), 2).offerTo(exporter, ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)output.asItem().getDescriptionId().replace("block.pfm.", "")));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItem(MinMaxBounds.Ints count, ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of((HolderGetter)PFMRecipeProvider.createWrapperLookup().lookupOrThrow(Registries.ITEM), new ItemLike[]{item}).withCount(count).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItem(ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of((HolderGetter)PFMRecipeProvider.createWrapperLookup().lookupOrThrow(Registries.ITEM), new ItemLike[]{item}).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromIngredient(Ingredient item) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Holder item1 : item.items().toList()) {
            if (items.contains(item1.value())) continue;
            items.add((Item)item1.value());
        }
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of(null, (ItemLike[])items.toArray(new Item[0])).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromTag(TagKey<Item> tag) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.item().of((HolderGetter)PFMRecipeProvider.createWrapperLookup().lookupOrThrow(Registries.ITEM), tag).build());
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromPredicates(ItemPredicate.Builder ... predicates) {
        return PFMRecipeProvider.conditionsFromItemPredicates((ItemPredicate[])Arrays.stream(predicates).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItemPredicates(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    private static String getItemPath(Ingredient item) {
        List n = item.items().toList();
        if (!n.isEmpty()) {
            return BuiltInRegistries.ITEM.getKey((Object)((Item)((Holder)n.getFirst()).value())).getPath();
        }
        return item.toString();
    }

    private static String getItemPath(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }
}

