/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.particlemoths;

import io.github.thepoultryman.particlemoths.ParticleMoths;
import io.github.thepoultryman.particlemoths.config.ParticleMothsConfig;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;

public class MothSpawnHelper {
    private static final Random random = new Random();

    public static boolean shouldSpawnMoth(Minecraft client) {
        boolean basicCheck = ParticleMothsConfig.spawnMoths(ParticleMothsConfig.MothSpawnMode.WORLD) && !client.isPaused();
        boolean probabilityCheck = (double)random.nextInt(100 - (int)ParticleMothsConfig.mothCount) < ParticleMothsConfig.spawnProbability;
        return basicCheck && probabilityCheck;
    }

    public static boolean isValidMothSpawn(Level level, BlockPos pos, Minecraft client) {
        boolean initialCheck;
        boolean bl = initialCheck = !MothSpawnHelper.isInRainOrWater(level, pos) && MothSpawnHelper.isWithinHeightLimits(pos.getY());
        if (client.player != null) {
            return initialCheck && !client.player.clientLevel.canSeeSky(client.player.getOnPos());
        }
        return false;
    }

    public static BlockPos getSpawnCoordinates(BlockPos pos) {
        int[] spawnBound = new int[]{ParticleMothsConfig.xSpawnDistance, ParticleMothsConfig.ySpawnDistance, ParticleMothsConfig.zSpawnDistance};
        int spawnX = pos.getX() + random.nextInt(-spawnBound[0], spawnBound[0]);
        int spawnY = pos.getY() + random.nextInt(-spawnBound[1], spawnBound[1]);
        int spawnZ = pos.getZ() + random.nextInt(-spawnBound[2], spawnBound[2]);
        return new BlockPos(spawnX, spawnY, spawnZ);
    }

    public static BlockPos getBlockSpawnCoordinates(BlockPos pos) {
        int[] spawnBound = new int[]{ParticleMothsConfig.xBlockSpawnDistance, ParticleMothsConfig.yBlockSpawnDistance, ParticleMothsConfig.zBlockSpawnDistance};
        int spawnX = pos.getX() + random.nextInt(-spawnBound[0], spawnBound[0]);
        int spawnY = pos.getY() + random.nextInt(-spawnBound[1], spawnBound[1]);
        int spawnZ = pos.getZ() + random.nextInt(-spawnBound[2], spawnBound[2]);
        return new BlockPos(spawnX, spawnY, spawnZ);
    }

    public static double[] getVelocity() {
        if (!ParticleMothsConfig.specificVelocities) {
            double velocity = random.nextDouble(-0.75, 0.75) * (ParticleMothsConfig.xVelocity / 100.0);
            return new double[]{velocity, velocity, velocity};
        }
        double velocityX = random.nextDouble(-0.75, 0.75) * (ParticleMothsConfig.xVelocity / 100.0);
        double velocityY = random.nextDouble(-0.75, 0.75) * (ParticleMothsConfig.yVelocity / 100.0);
        double velocityZ = random.nextDouble(-0.75, 0.75) * (ParticleMothsConfig.zVelocity / 100.0);
        return new double[]{velocityX, velocityY, velocityZ};
    }

    public static void spawnMothByBlock(Level level, BlockPos pos) {
        if (!ParticleMothsConfig.spawnMoths(ParticleMothsConfig.MothSpawnMode.WORLD) || (double)random.nextFloat(100.0f) > ParticleMothsConfig.blockSpawnProbability / 2.0) {
            return;
        }
        BlockPos spawnPos = MothSpawnHelper.getBlockSpawnCoordinates(pos);
        if (MothSpawnHelper.isInRainOrWater(level, spawnPos)) {
            return;
        }
        double[] velocities = MothSpawnHelper.getVelocity();
        level.addParticle((ParticleOptions)ParticleMoths.getOptions(), (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ(), velocities[0] / 5.0, velocities[1] / 5.0, velocities[2] / 5.0);
    }

    public static boolean isInRainOrWater(Level level, BlockPos pos) {
        return level.isRainingAt(pos) || level.isWaterAt(pos);
    }

    public static boolean isWithinHeightLimits(int yLevel) {
        return yLevel >= ParticleMothsConfig.negHeightLimit && yLevel <= ParticleMothsConfig.posHeightLimit;
    }
}

