/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.placeableblazerods_common_neoforge.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlazeRodBlock
extends RodBlock {
    public static final MapCodec<BlazeRodBlock> CODEC = BlazeRodBlock.simpleCodec(BlazeRodBlock::new);

    @NotNull
    public MapCodec<BlazeRodBlock> codec() {
        return CODEC;
    }

    public BlazeRodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.getClickedFace();
        BlockState blockstate = blockPlaceContext.getLevel().getBlockState(blockPlaceContext.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public void animateTick(BlockState blockState, @NotNull Level level, BlockPos blockPos, RandomSource randomSource) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        double d0 = (double)blockPos.getX() + 0.55 - (double)(randomSource.nextFloat() * 0.1f);
        double d1 = (double)blockPos.getY() + 0.55 - (double)(randomSource.nextFloat() * 0.1f);
        double d2 = (double)blockPos.getZ() + 0.55 - (double)(randomSource.nextFloat() * 0.1f);
        double d3 = 0.4f - (randomSource.nextFloat() + randomSource.nextFloat()) * 0.4f;
        if (randomSource.nextInt(5) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0 + (double)direction.getStepX() * d3, d1 + (double)direction.getStepY() * d3, d2 + (double)direction.getStepZ() * d3, randomSource.nextGaussian() * 0.005, randomSource.nextGaussian() * 0.005, randomSource.nextGaussian() * 0.005);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

