/*
 * Decompiled with CFR 0.152.
 */
package ru.nern.playerladder;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import ru.nern.playerladder.config.ServerConfig;

public class SharedHandler {
    private static final Set<EntityType<?>> entityTypesToExclude = Sets.newHashSet();
    private static final Set<TagKey<EntityType<?>>> entityTagsToExclude = Sets.newHashSet();

    public static InteractionResult rideEntity(Player player, Entity newVehicle, Level level, InteractionHand hand) {
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && SharedHandler.canPickUpOrRideLiving(newVehicle) && player.getItemInHand(hand).isEmpty()) {
            Entity vehicle = SharedHandler.getHighestOrSelf(newVehicle, (Entity)player, ServerConfig.stepUpLimit);
            if (vehicle == null) {
                return InteractionResult.FAIL;
            }
            player.startRiding(vehicle);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult pickUpEntity(Player player, Entity newPassenger, Level level, InteractionHand hand) {
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && SharedHandler.canPickUpOrRideLiving(newPassenger) && player.getItemInHand(hand).isEmpty()) {
            Entity vehicle = SharedHandler.getHighestOrSelf((Entity)player, newPassenger, ServerConfig.pickUpLimit);
            if (vehicle == null) {
                return InteractionResult.FAIL;
            }
            newPassenger.startRiding(vehicle);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static Entity getHighestOrSelf(Entity vehicle, Entity newPassenger, int limit) {
        int count = -1;
        while (vehicle.isVehicle()) {
            if ((vehicle = vehicle.getFirstPassenger()) != newPassenger && ++count < limit) continue;
            return null;
        }
        return vehicle;
    }

    private static boolean canPickUpOrRideLiving(Entity entity) {
        if (entity instanceof Player) {
            return ServerConfig.allowPlayers;
        }
        return ServerConfig.allowLivingEntities && !entityTypesToExclude.contains(entity.getType()) && entityTagsToExclude.stream().noneMatch(tag -> entity.getType().is(tag));
    }

    public static void onMount(Entity vehicle, Entity passenger) {
        if (!vehicle.level().isClientSide && vehicle instanceof Player) {
            ((ServerPlayer)vehicle).connection.send((Packet)new ClientboundSetPassengersPacket(vehicle));
        }
    }

    public static void onDismount(Entity vehicle) {
        if (!vehicle.level().isClientSide && vehicle instanceof Player) {
            ((ServerPlayer)vehicle).connection.send((Packet)new ClientboundSetPassengersPacket(vehicle));
        }
    }

    public static void onPlayerTick(Player player) {
        if (!player.level().isClientSide && player.onGround() && player.isVehicle() && player.isCrouching()) {
            player.getFirstPassenger().stopRiding();
        }
    }

    public static void onLogOut(Player player) {
        if (player.isPassenger() && player.getVehicle() instanceof Player) {
            player.stopRiding();
        }
    }

    public static void onGameModeChange(Player player, GameType newGameMode) {
        if (player.isVehicle() && newGameMode == GameType.SPECTATOR) {
            player.getFirstPassenger().stopRiding();
        }
    }

    private static void addExcludedEntityType(String entity) {
        try {
            Optional type = EntityType.byString((String)entity);
            type.ifPresent(entityTypesToExclude::add);
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
    }

    private static void addExcludedEntityTag(String tag) {
        try {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag.substring(1)));
            entityTagsToExclude.add(tagKey);
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
    }

    public static void setExcludedEntries(List<String> entries) {
        entityTagsToExclude.clear();
        entityTypesToExclude.clear();
        for (String entry : entries) {
            if (entry.isEmpty()) continue;
            if (entry.startsWith("#")) {
                SharedHandler.addExcludedEntityTag(entry);
                continue;
            }
            SharedHandler.addExcludedEntityType(entry);
        }
    }
}

