/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.pottery.PotteryClient;
import com.supermartijn642.pottery.PotteryConfig;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotEventHandlers;
import com.supermartijn642.pottery.content.PotRecipe;
import com.supermartijn642.pottery.content.PotType;
import com.supermartijn642.pottery.generators.PotteryAtlasSourceGenerator;
import com.supermartijn642.pottery.generators.PotteryBlockStateGenerator;
import com.supermartijn642.pottery.generators.PotteryItemInfoGenerator;
import com.supermartijn642.pottery.generators.PotteryLanguageGenerator;
import com.supermartijn642.pottery.generators.PotteryLootTableGenerator;
import com.supermartijn642.pottery.generators.PotteryModelGenerator;
import com.supermartijn642.pottery.generators.PotteryRecipeGenerator;
import com.supermartijn642.pottery.generators.PotteryTextureGenerator;
import net.neoforged.fml.common.Mod;

@Mod(value="pottery")
public class Pottery {
    public static final String MODID = "pottery";
    public static final CreativeItemGroup ITEM_GROUP = CreativeItemGroup.create((String)"pottery", () -> PotType.DEFAULT.getItem(PotColor.WHITE)).filler(consumer -> {
        for (PotType type : PotType.values()) {
            for (PotColor color : PotColor.values()) {
                consumer.accept(type.getItem(color).getDefaultInstance());
            }
        }
    });

    public Pottery() {
        PotEventHandlers.registerListeners();
        PotteryConfig.init();
        Pottery.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            PotteryClient.register();
        }
        Pottery.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)MODID);
        for (PotType type : PotType.values()) {
            handler.registerBlockCallback(type::registerBlocks);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItems);
        }
        handler.registerRecipeSerializer("pot", () -> PotRecipe.SERIALIZER);
    }

    public static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)MODID);
        handler.addGenerator(PotteryAtlasSourceGenerator::new);
        handler.addGenerator(PotteryBlockStateGenerator::new);
        handler.addGenerator(cache -> new PotteryItemInfoGenerator((ResourceCache)cache));
        handler.addGenerator(PotteryLanguageGenerator::new);
        handler.addGenerator(PotteryLootTableGenerator::new);
        handler.addGenerator(PotteryModelGenerator::new);
        handler.addGenerator(PotteryTextureGenerator::new);
        handler.addGenerator(PotteryRecipeGenerator::new);
    }
}

