/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.pottery.content.PotBlock;
import com.supermartijn642.pottery.content.PotType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.Nullable;

public class PotBlockEntity
extends BaseBlockEntity
implements RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem {
    private PotDecorations decorations = PotDecorations.EMPTY;
    private ItemStack items = ItemStack.EMPTY;
    public long wobbleStartedAtTick;
    @Nullable
    public DecoratedPotBlockEntity.WobbleStyle lastWobbleStyle;
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;

    public PotBlockEntity(PotType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
    }

    public ItemStack itemFromDecorations() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    public PotDecorations getDecorations() {
        return this.decorations;
    }

    public void updateDecorations(PotDecorations decorations) {
        this.decorations = decorations;
        this.dataChanged();
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue(PotBlock.HORIZONTAL_FACING);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceKey<LootTable> lootTable) {
        this.lootTable = lootTable;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.items;
    }

    public ItemStack splitTheItem(int count) {
        this.unpackLootTable(null);
        ItemStack split = this.items.split(count);
        if (this.items.isEmpty()) {
            this.items = ItemStack.EMPTY;
        }
        return split;
    }

    public void setTheItem(ItemStack stack) {
        this.unpackLootTable(null);
        this.items = stack;
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public void wobble(DecoratedPotBlockEntity.WobbleStyle style) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, style.ordinal());
    }

    public boolean triggerEvent(int identifier, int data) {
        if (this.level != null && identifier == 1 && data >= 0 && data < DecoratedPotBlockEntity.WobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.level.getGameTime();
            this.lastWobbleStyle = DecoratedPotBlockEntity.WobbleStyle.values()[data];
            return true;
        }
        return super.triggerEvent(identifier, data);
    }

    protected CompoundTag writeData() {
        CompoundTag data = new CompoundTag();
        if (this.decorations.equals((Object)PotDecorations.EMPTY)) {
            data.putBoolean("decorationsEmpty", true);
        } else {
            this.decorations.save(data);
        }
        if (!this.trySaveLootTable(data) && !this.items.isEmpty()) {
            data.put("items", this.items.saveOptional((HolderLookup.Provider)this.level.registryAccess()));
        }
        return data;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.decorations.save(compound);
    }

    protected CompoundTag writeItemStackData() {
        CompoundTag data = this.writeData();
        if (data != null) {
            data.remove("decorationsEmpty");
        }
        return data;
    }

    protected void readData(CompoundTag data) {
        this.decorations = PotDecorations.load((CompoundTag)data);
        if (!this.tryLoadLootTable(data)) {
            this.items = data.contains("items", 10) ? ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)data.getCompound("items")) : ItemStack.EMPTY;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.POT_DECORATIONS, (Object)this.decorations);
        builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.items)));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.decorations = (PotDecorations)dataComponentInput.getOrDefault(DataComponents.POT_DECORATIONS, (Object)PotDecorations.EMPTY);
        this.items = ((ItemContainerContents)dataComponentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne();
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.remove("sherds");
        compoundTag.remove("item");
    }
}

