/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.pottery.content.PotBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PotBlockRenderer
implements CustomBlockEntityRenderer<PotBlockEntity> {
    private static final RandomSource RANDOM_SOURCE = RandomSource.create();

    public void render(PotBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        float wobble;
        poseStack.pushPose();
        DecoratedPotBlockEntity.WobbleStyle wobbleStyle = entity.lastWobbleStyle;
        boolean cullFaces = true;
        if (wobbleStyle != null && entity.hasLevel() && (wobble = ((float)(entity.getLevel().getGameTime() - entity.wobbleStartedAtTick) + partialTicks) / (float)wobbleStyle.duration) >= 0.0f && wobble <= 1.0f) {
            Direction facing = entity.getFacing();
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - facing.toYRot()));
            if (wobbleStyle == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                float rotation = wobble * ((float)Math.PI * 2);
                float xAxis = -1.5f * (Mth.cos((float)rotation) + 0.5f) * Mth.sin((float)(rotation / 2.0f));
                poseStack.mulPose(Axis.XP.rotation(xAxis * 0.015625f));
                float zAxis = Mth.sin((float)rotation);
                poseStack.mulPose(Axis.ZP.rotation(zAxis * 0.015625f));
            } else {
                float h = Mth.sin((float)(-wobble * 3.0f * (float)Math.PI)) * 0.125f;
                float k = 1.0f - wobble;
                poseStack.mulPose(Axis.YP.rotation(h * k));
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot() - 180.0f));
            poseStack.translate(-0.5, 0.0, -0.5);
            cullFaces = false;
        }
        BlockRenderDispatcher blockRenderer = ClientUtils.getBlockRenderer();
        BlockState state = entity.getBlockState();
        BakedModel model = blockRenderer.getBlockModel(state);
        ModelData modelData = model.getModelData((BlockAndTintGetter)entity.getLevel(), entity.getBlockPos(), state, ModelData.EMPTY);
        Level level = entity.getLevel();
        long seed = state.getSeed(entity.getBlockPos());
        RANDOM_SOURCE.setSeed(seed);
        for (RenderType renderType : model.getRenderTypes(state, RANDOM_SOURCE, modelData)) {
            blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, state, entity.getBlockPos(), poseStack, bufferSource.getBuffer(renderType), cullFaces, RANDOM_SOURCE, seed, combinedOverlay, modelData, renderType);
        }
        poseStack.popPose();
    }
}

