/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.pottery.Pottery;
import com.supermartijn642.pottery.content.PotBlock;
import com.supermartijn642.pottery.content.PotBlockEntity;
import com.supermartijn642.pottery.content.PotColor;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;

public enum PotType {
    DEFAULT("Decorated Pot", 0, BlockShape.createBlockShape((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)),
    BASE("Pot", 0, BlockShape.or((BlockShape)BlockShape.createBlockShape((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), BlockShape.createBlockShape((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)})),
    SEALED("Sealed Pot", 1, BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), BlockShape.createBlockShape((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), BlockShape.createBlockShape((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)})),
    WIDE("Wide Pot", 1, BlockShape.or((BlockShape)BlockShape.createBlockShape((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), BlockShape.createBlockShape((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)})),
    TALL("Tall Pot", 1, BlockShape.or((BlockShape)BlockShape.createBlockShape((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), BlockShape.createBlockShape((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)17.0, (double)5.0, (double)11.0, (double)19.0, (double)11.0)})),
    SMALL("Small Pot", 0, BlockShape.or((BlockShape)BlockShape.createBlockShape((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0)}));

    private final String identifier;
    private final String translation;
    private final int extraBrickCount;
    private final BlockShape shape;
    private final EnumMap<PotColor, PotBlock> blocks = new EnumMap(PotColor.class);
    private final EnumMap<PotColor, BaseBlockItem> items = new EnumMap(PotColor.class);
    private BaseBlockEntityType<PotBlockEntity> blockEntityType;

    private PotType(String translation, int extraBrickCount, BlockShape shape) {
        this.extraBrickCount = extraBrickCount;
        this.identifier = this.name().toLowerCase(Locale.ROOT) + "_pot";
        this.translation = translation;
        this.shape = shape;
    }

    public void registerBlocks(RegistrationHandler.Helper<Block> helper) {
        for (PotColor color : PotColor.values()) {
            if (this == DEFAULT && color == PotColor.BLANK) continue;
            this.blocks.put(color, (PotBlock)((Object)helper.register(this.getIdentifier(color), (Object)new PotBlock(this, color))));
        }
    }

    public void registerBlockEntity(RegistrationHandler.Helper<BlockEntityType<?>> helper) {
        this.blockEntityType = (BaseBlockEntityType)helper.register(this.identifier, (Object)BaseBlockEntityType.create((pos, state) -> new PotBlockEntity(this, (BlockPos)pos, (BlockState)state), (Block[])((Block[])this.blocks.values().toArray(Block[]::new))));
    }

    public void registerItems(RegistrationHandler.Helper<Item> helper) {
        for (PotColor color : PotColor.values()) {
            if (this == DEFAULT && color == PotColor.BLANK) continue;
            PotBlock block = this.blocks.get((Object)color);
            ItemProperties properties = ItemProperties.create().group((CreativeModeTab)Pottery.ITEM_GROUP);
            properties.component(DataComponents.POT_DECORATIONS, (Object)PotDecorations.EMPTY);
            this.items.put(color, (BaseBlockItem)helper.register(this.getIdentifier(color), (Object)new BaseBlockItem((Block)block, properties)));
        }
    }

    public int getExtraBricks() {
        return this.extraBrickCount;
    }

    public BlockShape getShape() {
        return this.shape;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentifier(PotColor color) {
        return this.identifier + "_" + color.getIdentifier();
    }

    public Item getItem(PotColor color) {
        if (this == DEFAULT && color == PotColor.BLANK) {
            return Items.DECORATED_POT;
        }
        return (Item)this.items.get((Object)color);
    }

    public Block getBlock(PotColor color) {
        if (this == DEFAULT && color == PotColor.BLANK) {
            return Blocks.DECORATED_POT;
        }
        return (Block)this.blocks.get((Object)color);
    }

    public BaseBlockEntityType<PotBlockEntity> getBlockEntityType() {
        return this.blockEntityType;
    }

    public String getTranslation() {
        return this.translation;
    }
}

