/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BuiltinJson {
    private BuiltinJson() {
    }

    public static Result<ResourceLocation, Problem> parseIdentifier(JsonElement element) {
        return BuiltinJson.parseFromString(element, ResourceLocation::parse, () -> "Expected identifier", s -> "Invalid identifier `" + s + "`");
    }

    public static Result<String, Problem> parseIdentifierPath(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> ResourceLocation.withDefaultNamespace((String)s).getPath(), () -> "Expected identifier path", s -> "Invalid identifier path `" + s + "`");
    }

    public static Result<MobEffect, Problem> parseEffect(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.MOB_EFFECT, () -> "Expected effect", s -> "Invalid effect `" + s + "`", id -> "Unknown effect `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.MOB_EFFECT, () -> "Expected effect tag", s -> "Invalid effect tag `" + s + "`", id -> "Unknown effect tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectOrEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.MOB_EFFECT, () -> "Expected effect or effect tag", s -> "Invalid effect or effect tag `" + s + "`", id -> "Unknown effect or effect tag `" + String.valueOf(id) + "`");
    }

    public static Result<Block, Problem> parseBlock(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.BLOCK, () -> "Expected block", s -> "Invalid block `" + s + "`", id -> "Unknown block `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.BLOCK, () -> "Expected block tag", s -> "Invalid block tag `" + s + "`", id -> "Unknown block tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockOrBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.BLOCK, () -> "Expected block or block tag", s -> "Invalid block or block tag `" + s + "`", id -> "Unknown block or block tag `" + String.valueOf(id) + "`");
    }

    public static Result<DamageType, Problem> parseDamageType(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomething(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), () -> "Expected damage type", s -> "Invalid damage type `" + s + "`", id -> "Unknown damage type `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingTag(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), () -> "Expected damage type tag", s -> "Invalid damage type tag `" + s + "`", id -> "Unknown damage type tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeOrDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), () -> "Expected damage type or damage type tag", s -> "Invalid damage type or damage type tag `" + s + "`", id -> "Unknown damage type or damage type tag `" + String.valueOf(id) + "`");
    }

    public static Result<EntityType<?>, Problem> parseEntityType(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.ENTITY_TYPE, () -> "Expected entity type", s -> "Invalid entity type `" + s + "`", id -> "Unknown entity type `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.ENTITY_TYPE, () -> "Expected entity type tag", s -> "Invalid entity type tag `" + s + "`", id -> "Unknown entity type tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeOrEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.ENTITY_TYPE, () -> "Expected entity type or entity type tag", s -> "Invalid entity type or entity type tag `" + s + "`", id -> "Unknown entity type or entity type tag `" + String.valueOf(id) + "`");
    }

    public static Result<Item, Problem> parseItem(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.ITEM, () -> "Expected item", s -> "Invalid item `" + s + "`", id -> "Unknown item `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<Item>, Problem> parseItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.ITEM, () -> "Expected item tag", s -> "Invalid item tag `" + s + "`", id -> "Unknown item tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<Item>, Problem> parseItemOrItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.ITEM, () -> "Expected item or item tag", s -> "Invalid item or item tag `" + s + "`", id -> "Unknown item or item tag `" + String.valueOf(id) + "`");
    }

    public static Result<StatType<?>, Problem> parseStatType(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.STAT_TYPE, () -> "Expected stat type", s -> "Invalid stat type `" + s + "`", id -> "Unknown stat type `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.STAT_TYPE, () -> "Expected stat type tag", s -> "Invalid stat type tag `" + s + "`", id -> "Unknown stat type tag `" + String.valueOf(id) + "`");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeOrStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.STAT_TYPE, () -> "Expected stat type or stat type tag", s -> "Invalid stat type or stat type tag `" + s + "`", id -> "Unknown stat type or stat type tag `" + String.valueOf(id) + "`");
    }

    public static Result<StatePropertiesPredicate, Problem> parseStatePredicate(JsonElement element) {
        try {
            return Result.success((StatePropertiesPredicate)StatePropertiesPredicate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected state predicate"));
        }
    }

    public static Result<NbtPredicate, Problem> parseNbtPredicate(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return new NbtPredicate(TagParser.parseTag((String)s));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, () -> "Expected state predicate", s -> "Invalid state predicate `" + s + "`");
    }

    public static Result<Stat<?>, Problem> parseStat(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> BuiltinJson.getOrCreateStat((StatType)BuiltInRegistries.STAT_TYPE.getOptional(ResourceLocation.bySeparator((String)id.getNamespace(), (char)'.')).orElseThrow(), ResourceLocation.bySeparator((String)id.getPath(), (char)'.')), () -> "Expected stat", s -> "Invalid stat `" + s + "`", id -> "Unknown stat `" + String.valueOf(id) + "`");
    }

    private static <T> Stat<T> getOrCreateStat(StatType<T> statType, ResourceLocation id) {
        return statType.get(statType.getRegistry().getOptional(id).orElseThrow());
    }

    public static Result<CompoundTag, Problem> parseNbt(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return TagParser.parseTag((String)s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, () -> "Expected NBT", s -> "Invalid NBT `" + s + "`");
    }

    public static Result<DataComponentPatch, Problem> parseComponentChanges(JsonElement element) {
        try {
            return Result.success((DataComponentPatch)DataComponentPatch.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid nbt"));
        }
    }

    public static Result<ItemStack, Problem> parseItemStack(JsonElement element) {
        try {
            return element.getAsObject().andThen(rootObject -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                Optional item = rootObject.get("item").andThen(BuiltinJson::parseItem).ifFailure(problems::add).getSuccess();
                Optional components = rootObject.get("components").getSuccess().flatMap(nbtElement -> BuiltinJson.parseComponentChanges(nbtElement).ifFailure(problems::add).getSuccess());
                if (problems.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    components.ifPresent(arg_0 -> ((ItemStack)itemStack).applyComponentsAndValidate(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Problem.combine(problems));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected item stack"));
        }
    }

    public static Result<AdvancementType, Problem> parseFrame(JsonElement element) {
        try {
            return Result.success((AdvancementType)AdvancementType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected frame"));
        }
    }

    public static Result<Component, Problem> parseText(JsonElement element, RegistryAccess manager) {
        try {
            return Result.success(Component.Serializer.fromJson((com.google.gson.JsonElement)element.getJson(), (HolderLookup.Provider)manager));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected text"));
        }
    }

    public static Result<Attribute, Problem> parseAttribute(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> {
            if (id.getNamespace().equals("puffish_skills")) {
                id = ResourceLocation.fromNamespaceAndPath((String)"puffish_attributes", (String)id.getPath());
            }
            return (Attribute)BuiltInRegistries.ATTRIBUTE.getOptional(id).orElseThrow();
        }, () -> "Expected attribute", s -> "Invalid attribute `" + s + "`", id -> "Unknown attribute `" + String.valueOf(id) + "`");
    }

    public static Result<AttributeModifier.Operation, Problem> parseAttributeOperation(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> switch (s) {
            case "add", "add_value", "addition" -> AttributeModifier.Operation.ADD_VALUE;
            case "multiply_base", "add_multiplied_base" -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            case "multiply_total", "add_multiplied_total" -> AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            default -> throw new RuntimeException();
        }, () -> "Expected attribute operation", s -> "Invalid attribute operation `" + s + "`");
    }

    private static <T> Result<T, Problem> parseFromString(JsonElement element, Function<String, T> parser, Supplier<String> expected, Function<String, String> invalid) {
        try {
            String s = element.getJson().getAsString();
            try {
                return Result.success(parser.apply(s));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem(invalid.apply(s)));
            }
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(expected.get()));
        }
    }

    private static <T> Result<T, Problem> parseFromIdentifier(JsonElement element, Function<ResourceLocation, T> parser, Supplier<String> expected, Function<String, String> invalid, Function<ResourceLocation, String> unknown) {
        return BuiltinJson.parseFromString(element, ResourceLocation::parse, expected, invalid).andThen(id -> {
            try {
                return Result.success(parser.apply((ResourceLocation)id));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem((String)unknown.apply((ResourceLocation)id)));
            }
        });
    }

    private static <T> Result<T, Problem> parseSomething(JsonElement element, Registry<T> registry, Supplier<String> expected, Function<String, String> invalid, Function<ResourceLocation, String> unknown) {
        return BuiltinJson.parseFromIdentifier(element, id -> registry.getOptional(id).orElseThrow(), expected, invalid, unknown);
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingTag(JsonElement element, Registry<T> registry, Supplier<String> expected, Function<String, String> invalid, Function<ResourceLocation, String> unknown) {
        return BuiltinJson.parseFromString(element, s -> s.startsWith("#") ? ResourceLocation.parse((String)s.substring(1)) : ResourceLocation.parse((String)s), expected, invalid).andThen(id -> {
            try {
                return Result.success((HolderSet)registry.get(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id)).orElseThrow());
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem((String)unknown.apply((ResourceLocation)id)));
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static <T> Result<HolderSet<T>, Problem> parseSomethingOrSomethingTag(JsonElement element, Registry<T> registry, Supplier<String> expected, Function<String, String> invalid, Function<ResourceLocation, String> unknown) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

