/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class PointsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"points").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            Category category = CategoryArgumentType.getCategory((CommandContext<CommandSourceStack>)context, "category");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            for (ServerPlayer player : players) {
                category.addExtraPoints(player, count);
            }
            CommandUtils.sendSuccess((CommandContext<CommandSourceStack>)context, players, "points.add", count, category.getId());
            return players.size();
        })))))).then(Commands.literal((String)"set").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            Category category = CategoryArgumentType.getCategory((CommandContext<CommandSourceStack>)context, "category");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            for (ServerPlayer player : players) {
                category.setExtraPoints(player, count);
            }
            CommandUtils.sendSuccess((CommandContext<CommandSourceStack>)context, players, "points.set", count, category.getId());
            return players.size();
        })))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            Category category = CategoryArgumentType.getCategory((CommandContext<CommandSourceStack>)context, "category");
            int count = category.getExtraPoints(player);
            CommandUtils.sendSuccess((CommandContext<CommandSourceStack>)context, player, "points.get", count, category.getId());
            return count;
        }))));
    }
}

