/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.util.DisposeContext;

public class SkillDefinitionsConfig {
    private final Map<String, SkillDefinitionConfig> definitions;

    private SkillDefinitionsConfig(Map<String, SkillDefinitionConfig> definitions) {
        this.definitions = definitions;
    }

    public static Result<SkillDefinitionsConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> SkillDefinitionsConfig.parse(rootObject, context));
    }

    public static Result<SkillDefinitionsConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        return rootObject.getAsMap((id, element) -> SkillDefinitionConfig.parse(id, element, context)).mapFailure(problems -> Problem.combine(problems.values())).mapSuccess(SkillDefinitionsConfig::new);
    }

    public Optional<SkillDefinitionConfig> getById(String id) {
        return Optional.ofNullable(this.definitions.get(id));
    }

    public Collection<SkillDefinitionConfig> getAll() {
        return this.definitions.values();
    }

    public void dispose(DisposeContext context) {
        for (SkillDefinitionConfig definition : this.definitions.values()) {
            definition.dispose(context);
        }
    }
}

