/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.LegacyCalculation;
import net.puffish.skillsmod.calculation.operation.LegacyOperationRegistry;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.StatCondition;

public class IncreaseStatExperienceSource
implements ExperienceSource {
    private static final ResourceLocation ID = SkillsMod.createIdentifier("increase_stat");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);
    private final Calculation<Data> calculation;

    private IncreaseStatExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, IncreaseStatExperienceSource::parse);
    }

    private static Result<IncreaseStatExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse(rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(IncreaseStatExperienceSource::new));
    }

    public int getValue(ServerPlayer player, Stat<?> stat, int amount) {
        return (int)Math.round(this.calculation.evaluate(new Data(player, stat, amount)));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_stat"), BuiltinPrototypes.STAT, OperationFactory.create(Data::stat));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_increase_amount"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.amount()));
        LegacyOperationRegistry<Data> legacy = new LegacyOperationRegistry<Data>(PROTOTYPE);
        legacy.registerBooleanFunction("stat", StatCondition::parse, Data::stat);
        legacy.registerNumberFunction("player_effect", effect -> effect.getAmplifier() + 1, EffectOperation::parse, Data::player);
        legacy.registerNumberFunction("player_attribute", AttributeInstance::getValue, AttributeOperation::parse, Data::player);
        legacy.registerNumberFunction("amount", data -> data.amount());
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("player"), SkillsMod.createIdentifier("get_player"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("stat"), SkillsMod.createIdentifier("get_stat"));
        LegacyBuiltinPrototypes.registerAlias(PROTOTYPE, SkillsMod.createIdentifier("amount"), SkillsMod.createIdentifier("get_increase_amount"));
    }

    private record Data(ServerPlayer player, Stat<?> stat, int amount) {
    }
}

