/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.events;

import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.config.ConfigHandler;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.Level;

public class PkEntityEvents {
    public static boolean onEntityJoin(Entity entity, ServerLevel level) {
        if (entity.getTags().contains("pumpkillagersquest.removed")) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return false;
        }
        Set entityTags = entity.getTags();
        if (entity instanceof Pig) {
            if (entityTags.contains("pumpkillagersquest.pumpkincheck") || level.isClientSide) {
                return true;
            }
            entity.getTags().add("pumpkillagersquest.pumpkincheck");
            if (GlobalVariables.random.nextDouble() <= ConfigHandler.chanceForPumpkinBlockToSpawnOnPigSpawn) {
                if (!Data.spawnPumpkin.containsKey(level)) {
                    Data.spawnPumpkin.put((Level)level, new ArrayList());
                }
                Data.spawnPumpkin.get(level).add((LivingEntity)entity);
            }
        } else if (entity instanceof Husk) {
            Husk husk = (Husk)entity;
            if (husk.hasCustomName() && entity.getCustomName().getString().equals("The Ghost Knight") && husk.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof PlayerHeadItem) {
                EntityFunctions.getTargetSelector((Mob)husk).removeAllGoals(goal -> true);
                EntityFunctions.getTargetSelector((Mob)husk).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)husk, Player.class, true));
            }
        } else {
            if (entityTags.contains("pumpkillagersquest.summoned")) {
                if (entityTags.contains("pumpkillagersquest.justadded")) {
                    entity.getTags().remove("pumpkillagersquest.justadded");
                    return true;
                }
                entity.remove(Entity.RemovalReason.DISCARDED);
                return false;
            }
            if (Util.isPumpkillager(entity)) {
                Villager pumpkillager = (Villager)entity;
                if (entityTags.contains("pumpkillagersquest.justadded")) {
                    entity.getTags().remove("pumpkillagersquest.justadded");
                    if (!Data.allPumpkillagers.get(level).contains(pumpkillager)) {
                        Data.allPumpkillagers.get(level).add(pumpkillager);
                    }
                    return true;
                }
                Manage.resetPlacedBlocks((Level)level, pumpkillager.blockPosition());
                pumpkillager.remove(Entity.RemovalReason.DISCARDED);
                return false;
            }
            if (Util.isPrisoner(entity)) {
                Villager prisoner = (Villager)entity;
                if (entityTags.contains("pumpkillagersquest.justadded") || entityTags.contains("pumpkillagersquest.persistent")) {
                    entity.getTags().remove("pumpkillagersquest.justadded");
                    if (!Data.allPrisoners.get(level).contains(prisoner)) {
                        Data.allPrisoners.get(level).add(prisoner);
                    }
                    return true;
                }
                prisoner.remove(Entity.RemovalReason.DISCARDED);
                return false;
            }
        }
        return true;
    }

    public static void onEntityLeave(Entity entity, Level level) {
        if (entity instanceof Villager) {
            if (Util.isPumpkillager(entity)) {
                Villager pumpkillager = (Villager)entity;
                if (!level.isClientSide && entity.getTags().contains("pumpkillagersquest.finalform")) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (Entity serverEntity : serverLevel.getAllEntities()) {
                        if (!serverEntity.getTags().contains("pumpkillagersquest.summoned") || !(serverEntity instanceof LivingEntity)) continue;
                        Manage.yeetLivingEntityIntoSky(level, (LivingEntity)serverEntity);
                    }
                }
                if (Data.allPumpkillagers.containsKey(level)) {
                    Data.allPumpkillagers.get(level).remove(pumpkillager);
                }
                Data.pumpkillagerPositions.remove(pumpkillager);
                Data.pumpkillagerPlayerTarget.remove(pumpkillager);
                Data.pumpkillagerBossEvents.remove(pumpkillager);
            } else if (Util.isPrisoner(entity) && Data.allPrisoners.containsKey(level)) {
                Data.allPrisoners.get(level).remove((Villager)entity);
            }
        }
    }

    public static void onItemPickup(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide) {
            return;
        }
        if (!itemStack.getItem().equals(Items.PAPER)) {
            return;
        }
        String itemName = itemStack.getHoverName().getString();
        if (!itemName.contains("Prisoner Coordinates: ")) {
            return;
        }
        if (itemName.endsWith(".")) {
            MessageFunctions.sendMessage((Player)player, (String)"As you pick up the piece of paper, you see coordinates to a prisoner camp written on it. You feel bad about unleashing the Pumpkillager back into the world. Maybe a prisoner can help you stop him?", (ChatFormatting)ChatFormatting.GRAY, (boolean)true);
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)itemName.replace(".", "")));
        }
        MessageFunctions.sendMessage((Player)player, (String)itemName, (ChatFormatting)ChatFormatting.GRAY, (boolean)true);
    }

    public static boolean onEntityHitByLightning(Level level, Entity entity, LightningBolt lightningBolt) {
        return !Util.isPumpkillager(entity) && !Util.isPrisoner(entity);
    }
}

