/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class AbstractModelProvider
implements DataProvider {
    private final String modId;
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    private final Set<Object> skipValidation = new HashSet<Object>();

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
    }

    public CompletableFuture<?> run(CachedOutput output) {
        BlockStateOutputImpl blockStateOutput = new BlockStateOutputImpl(this::isValid);
        ItemModelOutputImpl itemModelOutput = new ItemModelOutputImpl(this::isValid);
        ModelProvider.SimpleModelCollector modelOutput = new ModelProvider.SimpleModelCollector();
        this.addBlockModels(this.setupBlockModelGenerators(new BlockModelGenerators((Consumer)((Object)blockStateOutput), (ItemModelOutput)itemModelOutput, (BiConsumer)modelOutput)));
        this.addItemModels(new ItemModelGenerators((ItemModelOutput)itemModelOutput, (BiConsumer)modelOutput));
        blockStateOutput.validate();
        itemModelOutput.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateOutput.save(output, this.blockStatePathProvider), modelOutput.save(output, this.modelPathProvider), itemModelOutput.save(output, this.itemInfoPathProvider));
    }

    private BlockModelGenerators setupBlockModelGenerators(BlockModelGenerators blockModelGenerators) {
        blockModelGenerators.nonOrientableTrapdoor = new ArrayList(blockModelGenerators.nonOrientableTrapdoor);
        blockModelGenerators.fullBlockModelCustomGenerators = new HashMap(blockModelGenerators.fullBlockModelCustomGenerators);
        blockModelGenerators.texturedModels = new HashMap(blockModelGenerators.texturedModels);
        return blockModelGenerators;
    }

    private <T> boolean isValid(Holder.Reference<T> holder) {
        if (!this.skipAllValidation()) {
            if (holder.key().location().getNamespace().equals(this.modId)) {
                return !this.skipValidation.contains(holder.value());
            }
            return false;
        }
        return false;
    }

    public void addBlockModels(BlockModelGenerators blockModelGenerators) {
    }

    public void addItemModels(ItemModelGenerators itemModelGenerators) {
    }

    protected boolean skipAllValidation() {
        return false;
    }

    protected final void skipBlockValidation(Block block) {
        this.skipValidation.add(block);
    }

    protected final void skipItemValidation(Item item) {
        this.skipValidation.add(item);
    }

    public final String getName() {
        return "Model Definitions";
    }

    static class BlockStateOutputImpl
    extends ModelProvider.BlockStateGeneratorCollector {
        private final Predicate<Holder.Reference<Block>> filter;

        public BlockStateOutputImpl(Predicate<Holder.Reference<Block>> filter) {
            this.filter = filter;
        }

        public void validate() {
            List<ResourceLocation> list = BuiltInRegistries.BLOCK.listElements().filter(this.filter).filter(holder -> !this.generators.containsKey(holder.value())).map(holder -> holder.key().location()).toList();
            if (!list.isEmpty()) {
                throw new IllegalStateException("Missing blockstate definitions for: " + String.valueOf(list));
            }
        }
    }

    static class ItemModelOutputImpl
    extends ModelProvider.ItemInfoCollector
    implements CustomItemModelOutput {
        private final Predicate<Holder.Reference<Item>> filter;

        public ItemModelOutputImpl(Predicate<Holder.Reference<Item>> filter) {
            this.filter = filter;
        }

        @Override
        public void accept(Item item, ItemModel.Unbaked model, ClientItem.Properties properties) {
            this.register(item, new ClientItem(model, properties));
        }

        public void finalizeAndValidate() {
            BuiltInRegistries.ITEM.listElements().filter(this.filter).forEach(item -> {
                BlockItem blockItem;
                Object patt0$temp;
                if (!this.copies.containsKey(item.value()) && (patt0$temp = item.value()) instanceof BlockItem && !this.itemInfos.containsKey(blockItem = (BlockItem)patt0$temp)) {
                    ResourceLocation resourceLocation = ModelLocationUtils.getModelLocation((Block)blockItem.getBlock());
                    this.accept((Item)blockItem, ItemModelUtils.plainModel((ResourceLocation)resourceLocation));
                }
            });
            this.copies.forEach((item, item2) -> {
                ClientItem clientItem = (ClientItem)this.itemInfos.get(item2);
                if (clientItem == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(item2) + " -> " + String.valueOf(item));
                }
                this.register((Item)item, clientItem);
            });
            List<ResourceLocation> list = BuiltInRegistries.ITEM.listElements().filter(this.filter).filter(item -> !this.itemInfos.containsKey(item.value())).map(item -> item.key().location()).toList();
            if (!list.isEmpty()) {
                throw new IllegalStateException("Missing item model definitions for: " + String.valueOf(list));
            }
        }
    }

    public static interface CustomItemModelOutput
    extends ItemModelOutput {
        public void accept(Item var1, ItemModel.Unbaked var2, ClientItem.Properties var3);
    }
}

