/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2.models;

import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.impl.init.DyedSpawnEggItem;
import java.util.function.BiConsumer;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;

public final class ItemModelGenerationHelper {
    public static final ModelTemplate HORN = ModelTemplates.createItem((String)"goat_horn", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});
    public static final ModelTemplate TOOTING_HORN = ModelTemplates.createItem((String)"tooting_goat_horn", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});

    private ItemModelGenerationHelper() {
    }

    public static void generateFlatItem(Item item, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ItemModelGenerationHelper.createFlatItemModel(item, modelTemplate, (BiConsumer<ResourceLocation, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static ResourceLocation createFlatItemModel(Item item, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(item, item, modelTemplate, modelOutput);
    }

    public static void generateFlatItem(Item item, Item layerItem, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ItemModelGenerationHelper.createFlatItemModel(item, layerItem, modelTemplate, (BiConsumer<ResourceLocation, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static ResourceLocation createFlatItemModel(Item item, Item layerItem, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(item, ModelLocationHelper.getItemModel(layerItem), modelTemplate, modelOutput);
    }

    public static void generateFlatItem(Item item, ResourceLocation layer0Location, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ItemModelGenerationHelper.createFlatItemModel(item, layer0Location, modelTemplate, (BiConsumer<ResourceLocation, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static ResourceLocation createFlatItemModel(Item item, ResourceLocation layer0Location, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(ModelLocationHelper.getItemModel(item), layer0Location, modelTemplate, modelOutput);
    }

    public static ResourceLocation createFlatItemModel(ResourceLocation resourceLocation, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createFlatItemModel(resourceLocation, resourceLocation, modelTemplate, modelOutput);
    }

    public static ResourceLocation createFlatItemModel(ResourceLocation resourceLocation, ResourceLocation layer0Location, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return modelTemplate.create(resourceLocation, TextureMapping.layer0((ResourceLocation)layer0Location), modelOutput);
    }

    public static void generateLayeredItem(Item item, ResourceLocation layer0Location, ResourceLocation layer1Location, ModelTemplate modelTemplate, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ItemModelGenerationHelper.createLayeredItemModel(item, layer0Location, layer1Location, modelTemplate, (BiConsumer<ResourceLocation, ModelInstance>)itemModelGenerators.modelOutput)));
    }

    public static ResourceLocation createLayeredItemModel(Item item, ResourceLocation layer0Location, ResourceLocation layer1Location, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return ItemModelGenerationHelper.createLayeredItemModel(ModelLocationHelper.getItemModel(item), layer0Location, layer1Location, modelTemplate, modelOutput);
    }

    public static ResourceLocation createLayeredItemModel(ResourceLocation resourceLocation, ResourceLocation layer0Location, ResourceLocation layer1Location, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        return modelTemplate.create(resourceLocation, TextureMapping.layered((ResourceLocation)layer0Location, (ResourceLocation)layer1Location), modelOutput);
    }

    public static void generateBow(Item item, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.createFlatItemModel(item, ModelTemplates.BOW);
        itemModelGenerators.generateBow(item);
    }

    public static void generateSpawnEgg(Item item, ItemModelGenerators itemModelGenerators) {
        itemModelGenerators.generateSpawnEgg(item, ((DyedSpawnEggItem)item).backgroundColor(), ((DyedSpawnEggItem)item).highlightColor());
    }

    public static void generateHorn(Item item, ItemModelGenerators itemModelGenerators) {
        ItemModel.Unbaked falseModel = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, HORN));
        ItemModel.Unbaked trueModel = ItemModelUtils.plainModel((ResourceLocation)ItemModelGenerationHelper.createFlatItemModel(ModelLocationHelper.getItemModel(item, "_tooting"), ModelLocationHelper.getItemModel(item), TOOTING_HORN, (BiConsumer<ResourceLocation, ModelInstance>)itemModelGenerators.modelOutput));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), trueModel, falseModel);
    }

    public static void createHead(Block headBlock, Block wallHeadBlock, SkullBlock.Type type, BlockModelGenerators blockModelGenerators) {
        blockModelGenerators.createHead(headBlock, wallHeadBlock, type, ModelLocationUtils.decorateItemModelLocation((String)"template_skull"));
    }
}

