/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1;

import fuzs.puzzleslib.impl.client.core.ClientFactories;
import java.util.Objects;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RenderPropertyKey<T>(ResourceLocation resourceLocation) {
    @NotNull
    public static <T> T getRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key) {
        T renderProperty = ClientFactories.INSTANCE.getRenderProperty(renderState, key);
        Objects.requireNonNull(renderProperty, "render property " + String.valueOf(key) + " is null");
        return renderProperty;
    }

    public static <T> boolean containsRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key) {
        return ClientFactories.INSTANCE.getRenderProperty(renderState, key) != null;
    }

    public static <T> void setRenderProperty(EntityRenderState renderState, RenderPropertyKey<T> key, @Nullable T t) {
        ClientFactories.INSTANCE.setRenderProperty(renderState, key, t);
    }
}

