/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.util.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public final class ModelLoadingHelper {
    public static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json((String)"blockstates");
    public static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json((String)"models");

    private ModelLoadingHelper() {
    }

    @Deprecated
    public static BlockStateModelLoader.LoadedModels loadBlockState(ResourceManager resourceManager, Block block) {
        return ModelLoadingHelper.loadBlockState(resourceManager, block, (Executor)Util.backgroundExecutor()).join();
    }

    public static CompletableFuture<BlockStateModelLoader.LoadedModels> loadBlockState(ResourceManager resourceManager, Block block, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, BuiltInRegistries.BLOCK.getKey((Object)block), (StateDefinition<Block, BlockState>)block.getStateDefinition(), executor);
    }

    @Deprecated
    public static BlockStateModelLoader.LoadedModels loadBlockState(ResourceManager resourceManager, ResourceLocation resourceLocation, StateDefinition<Block, BlockState> stateDefinition) {
        return ModelLoadingHelper.loadBlockState(resourceManager, resourceLocation, stateDefinition, (Executor)Util.backgroundExecutor()).join();
    }

    public static CompletableFuture<BlockStateModelLoader.LoadedModels> loadBlockState(ResourceManager resourceManager, ResourceLocation resourceLocation, StateDefinition<Block, BlockState> stateDefinition, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, resourceLocation, resourceLocation, stateDefinition, executor);
    }

    public static CompletableFuture<BlockStateModelLoader.LoadedModels> loadBlockState(ResourceManager resourceManager, ResourceLocation oldResourceLocation, ResourceLocation newResourceLocation, StateDefinition<Block, BlockState> stateDefinition, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, oldResourceLocation, executor).thenCompose(loadedBlockModelDefinitions -> ModelLoadingHelper.loadBlockState(loadedBlockModelDefinitions, newResourceLocation, stateDefinition, executor));
    }

    public static CompletableFuture<List<BlockStateModelLoader.LoadedBlockModelDefinition>> loadBlockState(ResourceManager resourceManager, ResourceLocation resourceLocation, Executor executor) {
        return CompletableFuture.supplyAsync(() -> resourceManager.getResourceStack(BLOCKSTATE_LISTER.idToFile(resourceLocation)), executor).thenApply(resourceStack -> {
            ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition> blockModelDefinitions = new ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition>(resourceStack.size());
            for (Resource resource : resourceStack) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonObject jsonObject = GsonHelper.parse((Reader)reader);
                        BlockModelDefinition blockModelDefinition = BlockModelDefinition.fromJsonElement((JsonElement)jsonObject);
                        blockModelDefinitions.add(new BlockStateModelLoader.LoadedBlockModelDefinition(resource.sourcePackId(), blockModelDefinition));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{resourceLocation, resource.sourcePackId(), exception});
                }
            }
            return blockModelDefinitions;
        });
    }

    public static CompletableFuture<BlockStateModelLoader.LoadedModels> loadBlockState(List<BlockStateModelLoader.LoadedBlockModelDefinition> loadedBlockModelDefinitions, ResourceLocation resourceLocation, StateDefinition<Block, BlockState> stateDefinition, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return BlockStateModelLoader.loadBlockStateDefinitionStack((ResourceLocation)resourceLocation, (StateDefinition)stateDefinition, (List)loadedBlockModelDefinitions, null);
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.error("Failed to load blockstate definition {}", (Object)resourceLocation, (Object)exception);
                return null;
            }
        }, executor);
    }

    @Deprecated
    public static UnbakedModel loadBlockModel(ResourceManager resourceManager, ResourceLocation resourceLocation, UnbakedModel missingModel) {
        return ModelLoadingHelper.loadBlockModel(resourceManager, resourceLocation, (Executor)Util.backgroundExecutor(), missingModel).join();
    }

    public static CompletableFuture<UnbakedModel> loadBlockModel(ResourceManager resourceManager, ResourceLocation resourceLocation, Executor executor, UnbakedModel missingModel) {
        return CompletableFuture.supplyAsync(() -> resourceManager.getResource(MODEL_LISTER.idToFile(resourceLocation)), executor).thenApply(optional -> optional.map(resource -> {
            BlockModel blockModel;
            block8: {
                BufferedReader reader = resource.openAsReader();
                try {
                    blockModel = BlockModel.fromStream((Reader)reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PuzzlesLib.LOGGER.error("Failed to load model {}", (Object)resourceLocation, (Object)exception);
                        return null;
                    }
                }
                ((Reader)reader).close();
            }
            return blockModel;
        }).orElse(missingModel));
    }

    public static UnbakedBlockStateModel missingModel() {
        return new UnbakedBlockStateModel(){

            public BakedModel bake(ModelBaker baker) {
                return UnbakedModel.bakeWithTopModelValues((UnbakedModel)MissingBlockModel.missingModel(), (ModelBaker)baker, (ModelState)BlockModelRotation.X0_Y0);
            }

            public Object visualEqualityGroup(BlockState state) {
                return this;
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
            }
        };
    }
}

