/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.BlockInteractionsContext;
import fuzs.puzzleslib.api.core.v1.context.CompostableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.DataPackRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesModifyContext;
import fuzs.puzzleslib.api.core.v1.context.FlammableBlocksContext;
import fuzs.puzzleslib.api.core.v1.context.FuelValuesContext;
import fuzs.puzzleslib.api.core.v1.context.GameRegistriesContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.core.CommonFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.util.Strings;

public interface ModConstructor
extends BaseModConstructor {
    public static void construct(String modId, Supplier<ModConstructor> modConstructorSupplier) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id is empty");
        }
        ModConstructor modConstructor = modConstructorSupplier.get();
        ResourceLocation resourceLocation = ModContext.getPairingIdentifier(modId, modConstructor);
        PuzzlesLib.LOGGER.info("Constructing common components for {}", (Object)resourceLocation);
        ModContext modContext = ModContext.get(modId);
        modContext.beforeModConstruction();
        CommonFactories.INSTANCE.constructMod(modId, modConstructor);
        modContext.afterModConstruction(resourceLocation);
    }

    default public void onConstructMod() {
    }

    default public void onCommonSetup() {
    }

    default public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
    }

    default public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
    }

    default public void onEntityAttributeModification(EntityAttributesModifyContext context) {
    }

    default public void onRegisterBiomeModifications(BiomeModificationsContext context) {
    }

    default public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
    }

    default public void onRegisterFuelValues(FuelValuesContext context) {
    }

    default public void onRegisterCompostableBlocks(CompostableBlocksContext context) {
    }

    default public void onRegisterBlockInteractions(BlockInteractionsContext context) {
    }

    default public void onAddDataPackFinders(PackRepositorySourcesContext context) {
    }

    default public void onGameRegistriesContext(GameRegistriesContext context) {
    }

    default public void onDataPackRegistriesContext(DataPackRegistriesContext context) {
    }
}

