/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public final class ArmorMaterialBuilder {
    private static final ResourceLocation NO_RENDER_ASSET_ID = PuzzlesLibMod.id("no_render");
    private int durability;
    private Map<ArmorType, Integer> defense = (Map)Util.make(new EnumMap(ArmorType.class), map -> {
        for (ArmorType armorType : ArmorType.values()) {
            map.put(armorType, 0);
        }
    });
    private int enchantmentValue = 1;
    private Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
    private float toughness;
    private float knockbackResistance;
    private TagKey<Item> repairIngredient;
    private ResourceKey<EquipmentAsset> assetId;

    private ArmorMaterialBuilder() {
    }

    public static ArmorMaterialBuilder of(TagKey<Item> repairIngredient) {
        return new ArmorMaterialBuilder().setRepairIngredient(repairIngredient);
    }

    public static ArmorMaterialBuilder of(ResourceLocation assetId, TagKey<Item> repairIngredient) {
        return new ArmorMaterialBuilder().setAssetId(assetId).setRepairIngredient(repairIngredient);
    }

    @Deprecated(forRemoval=true)
    public static ArmorMaterialBuilder of(ResourceKey<EquipmentAsset> assetId, TagKey<Item> repairIngredient) {
        return new ArmorMaterialBuilder().setAssetId(assetId).setRepairIngredient(repairIngredient);
    }

    public static ArmorMaterialBuilder copyOf(ArmorMaterial armorMaterial) {
        return ArmorMaterialBuilder.of((ResourceKey<EquipmentAsset>)armorMaterial.assetId(), (TagKey<Item>)armorMaterial.repairIngredient()).setDurability(armorMaterial.durability()).setDefense(armorMaterial.defense()).setEnchantmentValue(armorMaterial.enchantmentValue()).setEquipSound((Holder<SoundEvent>)armorMaterial.equipSound()).setToughness(armorMaterial.toughness()).setKnockbackResistance(armorMaterial.knockbackResistance());
    }

    public ArmorMaterialBuilder setDurability(int durability) {
        this.durability = durability;
        return this;
    }

    public ArmorMaterialBuilder setDefense(int defense) {
        return this.setDefense(defense, defense, defense, defense, defense);
    }

    public ArmorMaterialBuilder setDefense(int boots, int leggings, int chestplate, int helmet) {
        return this.setDefense(boots, leggings, chestplate, helmet, 0);
    }

    public ArmorMaterialBuilder setDefense(int boots, int leggings, int chestplate, int helmet, int body) {
        return this.setDefense(ArmorType.BOOTS, boots).setDefense(ArmorType.LEGGINGS, leggings).setDefense(ArmorType.CHESTPLATE, chestplate).setDefense(ArmorType.HELMET, helmet).setDefense(ArmorType.BODY, body);
    }

    public ArmorMaterialBuilder setDefense(ArmorType armorType, int defense) {
        this.defense.put(armorType, defense);
        return this;
    }

    private ArmorMaterialBuilder setDefense(Map<ArmorType, Integer> defense) {
        this.defense = defense;
        return this;
    }

    public ArmorMaterialBuilder setEnchantmentValue(int enchantmentValue) {
        this.enchantmentValue = enchantmentValue;
        return this;
    }

    public ArmorMaterialBuilder setEquipSound(Holder<SoundEvent> equipSound) {
        Objects.requireNonNull(equipSound, "equip sound is null");
        this.equipSound = equipSound;
        return this;
    }

    public ArmorMaterialBuilder setToughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ArmorMaterialBuilder setKnockbackResistance(float knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
        return this;
    }

    public ArmorMaterialBuilder setRepairIngredient(TagKey<Item> repairIngredient) {
        Objects.requireNonNull(repairIngredient, "repair ingredient is null");
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ArmorMaterialBuilder setAssetId(ResourceLocation assetId) {
        Objects.requireNonNull(assetId, "asset id is null");
        return this.setAssetId((ResourceKey<EquipmentAsset>)ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)assetId));
    }

    public ArmorMaterialBuilder setAssetId(ResourceKey<EquipmentAsset> assetId) {
        Objects.requireNonNull(assetId, "asset id is null");
        this.assetId = assetId;
        return this;
    }

    public ArmorMaterialBuilder setNoAssetId() {
        return this.setAssetId(NO_RENDER_ASSET_ID);
    }

    public ArmorMaterial build() {
        Objects.requireNonNull(this.defense, "defense map is null");
        Objects.requireNonNull(this.equipSound, "equip sound is null");
        Objects.requireNonNull(this.repairIngredient, "repair ingredient is null");
        Objects.requireNonNull(this.assetId, "asset id is null");
        return new ArmorMaterial(this.durability, (Map)Maps.immutableEnumMap(this.defense), this.enchantmentValue, this.equipSound, this.toughness, this.knockbackResistance, this.repairIngredient, this.assetId);
    }
}

