/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.util.v1;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class CodecExtras {
    public static final Codec<NonNullList<ItemStack>> NON_NULL_ITEM_STACK_LIST_CODEC = CodecExtras.nonNullList(ItemStack.CODEC, Predicate.not(ItemStack::isEmpty), ItemStack.EMPTY);

    private CodecExtras() {
    }

    public static <T> Codec<NonNullList<T>> nonNullList(Codec<T> codec, Predicate<T> filter, @Nullable T defaultValue) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("size").forGetter(NonNullList::size), (App)Codec.mapPair((MapCodec)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("slot"), (MapCodec)codec.fieldOf("item")).codec().listOf().fieldOf("items").forGetter(items -> IntStream.range(0, items.size()).mapToObj(index -> new Pair((Object)index, items.get(index))).filter(pair -> filter.test(pair.getSecond())).toList())).apply((Applicative)instance, (size, items) -> {
            NonNullList nonNullList = defaultValue != null ? NonNullList.withSize((int)size, (Object)defaultValue) : NonNullList.createWithCapacity((int)size);
            for (Pair pair : items) {
                nonNullList.set(((Integer)pair.getFirst()).intValue(), pair.getSecond());
            }
            return nonNullList;
        }));
    }

    public static Function<Tag, DataResult<CompoundTag>> mapCompoundTag() {
        return tag -> {
            DataResult dataResult;
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                dataResult = DataResult.success((Object)compoundTag);
            } else {
                dataResult = DataResult.error(() -> "Not a compound tag: " + String.valueOf(tag));
            }
            return dataResult;
        };
    }
}

