/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client;

import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.gui.v2.screen.ScreenSkipper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.impl.config.ConfigTranslationsManager;
import fuzs.puzzleslib.impl.core.EventHandlerProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class PuzzlesLibClient
implements ClientModConstructor {
    @Override
    public void onConstructMod() {
        PuzzlesLibClient.registerEventHandlers();
        PuzzlesLibClient.setupDevelopmentEnvironment();
    }

    private static void registerEventHandlers() {
        AddResourcePackReloadListenersCallback.EVENT.register(ConfigTranslationsManager::onAddResourcePackReloadListeners);
    }

    private static void setupDevelopmentEnvironment() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironmentWithoutDataGeneration("puzzleslib")) {
            return;
        }
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            PuzzlesLibClient.setupGameOptions();
        }
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            if (newScreen instanceof TitleScreen) {
                TitleScreen screen = (TitleScreen)newScreen;
                screen.fading = false;
            } else if (newScreen instanceof CreateWorldScreen) {
                CreateWorldScreen screen = (CreateWorldScreen)newScreen;
                screen.getUiState().setGameMode(WorldCreationUiState.SelectedGameMode.CREATIVE);
                screen.getUiState().setAllowCommands(true);
            }
            return EventResultHolder.pass();
        });
        ScreenEvents.beforeInit(TitleScreen.class).register((minecraft, screen, screenWidth, screenHeight, widgets) -> {
            Overlay patt0$temp = minecraft.getOverlay();
            if (patt0$temp instanceof LoadingOverlay) {
                LoadingOverlay loadingOverlay = (LoadingOverlay)patt0$temp;
                if (loadingOverlay.fadeOutStart != 0L) {
                    loadingOverlay.fadeOutStart = 0L;
                }
            }
        });
        AddToastCallback.EVENT.register((toastManager, toast) -> {
            SystemToast systemToast;
            if (toast instanceof SystemToast && (systemToast = (SystemToast)toast).getToken() == SystemToast.SystemToastId.UNSECURE_SERVER_WARNING) {
                return EventResult.INTERRUPT;
            }
            if (toastManager.freeSlotCount() == 0) {
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenSkipper.create().setTitleComponent("selectWorld.backupQuestion.experimental").setButtonComponent("selectWorld.backupJoinSkipButton").build();
        ScreenSkipper.create().setTitleComponent("selectWorld.warning.experimental.title").setButtonComponent(CommonComponents.GUI_YES).build();
        ScreenSkipper.create().setTitleComponent("controls.title").setButtonComponent("controls.keybinds").setLastTitleComponent("options.title").build();
        ScreenMouseEvents.beforeMouseClick(Screen.class).register((screen, mouseX, mouseY, button) -> {
            for (GuiEventListener guiEventListener : screen.children()) {
                if (!(guiEventListener instanceof EditBox) || !guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
                screen.setFocused(guiEventListener);
                if (button == 0) {
                    screen.setDragging(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(Screen.class).register((screen, mouseX, mouseY, button) -> {
            screen.setDragging(false);
            return screen.getChildAt(mouseX, mouseY).filter(EditBox.class::isInstance).filter(guiEventListener -> guiEventListener.mouseReleased(mouseX, mouseY, button)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(Screen.class).register((screen, mouseX, mouseY, button, dragX, dragY) -> screen.getFocused() instanceof EditBox && screen.isDragging() && button == 0 && screen.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    private static void setupGameOptions() {
        Minecraft minecraft = Minecraft.getInstance();
        boolean running = minecraft.running;
        minecraft.running = false;
        PuzzlesLibClient.initializeGameOptions(minecraft.options);
        minecraft.running = running;
    }

    public static void initializeGameOptions(Options options) {
        if (options.getFile().exists()) {
            return;
        }
        options.renderDistance().set((Object)16);
        options.framerateLimit().set((Object)60);
        options.narratorHotkey().set((Object)false);
        options.advancedItemTooltips = true;
        options.tutorialStep = TutorialSteps.NONE;
        options.joinedFirstServer = true;
        options.operatorItemsTab().set((Object)true);
        options.entityShadows().set((Object)false);
        options.realmsNotifications().set((Object)false);
        options.showSubtitles().set((Object)true);
        options.guiScale().set((Object)8);
        options.onboardAccessibility = false;
        options.skipMultiplayerWarning = true;
        options.damageTiltStrength().set((Object)0.0);
    }

    @Override
    public void onClientSetup() {
        EventHandlerProvider.tryRegister(ClientAbstractions.INSTANCE);
        if (ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironmentWithoutDataGeneration("puzzleslib")) {
            CreativeModeInventoryScreen.selectedTab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getValueOrThrow(CreativeModeTabs.SEARCH);
        }
    }
}

