/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.client.data.v2;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.SpriteSourceProvider;

public abstract class AbstractAtlasProvider
extends SpriteSourceProvider {
    public AbstractAtlasProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractAtlasProvider(String modId, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, modId);
    }

    protected final void gather() {
        this.addAtlases();
    }

    public abstract void addAtlases();

    protected SpriteSourceProvider.SourceList sheet(ResourceLocation resourceLocation) {
        ResourceLocation atlasLocation = (ResourceLocation)ModelManager.VANILLA_ATLASES.get(resourceLocation);
        Objects.requireNonNull(atlasLocation, "atlas for " + String.valueOf(resourceLocation) + " is null");
        return this.atlas(atlasLocation);
    }

    @Deprecated(forRemoval=true)
    public void addMaterial(Material material) {
        this.material(material);
    }

    public void material(Material material) {
        this.material(material.atlasLocation(), material.texture());
    }

    public void material(ResourceLocation atlasLocation, ResourceLocation textureLocation) {
        this.sheet(atlasLocation).addSource((SpriteSource)new SingleFile(textureLocation, Optional.empty()));
    }

    public String getName() {
        return "Atlases";
    }
}

